/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.client.impl.response;

import io.camunda.zeebe.client.api.response.Process;
import io.camunda.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.Objects;

public final class ProcessImpl
implements Process {
    private final long processDefinitionKey;
    private final String bpmnProcessId;
    private final int version;
    private final String resourceName;
    private final String tenantId;

    public ProcessImpl(GatewayOuterClass.ProcessMetadata process) {
        this(process.getProcessDefinitionKey(), process.getBpmnProcessId(), process.getVersion(), process.getResourceName(), process.getTenantId());
    }

    @Deprecated
    public ProcessImpl(long processDefinitionKey, String bpmnProcessId, int version, String resourceName) {
        this(processDefinitionKey, bpmnProcessId, version, resourceName, "<default>");
    }

    public ProcessImpl(long processDefinitionKey, String bpmnProcessId, int version, String resourceName, String tenantId) {
        this.processDefinitionKey = processDefinitionKey;
        this.bpmnProcessId = bpmnProcessId;
        this.version = version;
        this.resourceName = resourceName;
        this.tenantId = tenantId;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    public int hashCode() {
        return Objects.hash(this.processDefinitionKey, this.bpmnProcessId, this.version, this.resourceName, this.tenantId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessImpl process = (ProcessImpl)o;
        return this.processDefinitionKey == process.processDefinitionKey && this.version == process.version && Objects.equals(this.bpmnProcessId, process.bpmnProcessId) && Objects.equals(this.resourceName, process.resourceName) && Objects.equals(this.tenantId, process.tenantId);
    }

    public String toString() {
        return "ProcessImpl{processDefinitionKey=" + this.processDefinitionKey + ", bpmnProcessId='" + this.bpmnProcessId + '\'' + ", version=" + this.version + ", resourceName='" + this.resourceName + '\'' + ", tenantId='" + this.tenantId + '\'' + '}';
    }
}

