/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.Activity;
import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.camunda.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.util.ModelUtil;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class CompensationEventDefinitionValidator
implements ModelElementValidator<CompensateEventDefinition> {
    public Class<CompensateEventDefinition> getElementType() {
        return CompensateEventDefinition.class;
    }

    public void validate(CompensateEventDefinition compensateEventDefinition, ValidationResultCollector validationResultCollector) {
        String activityRef = compensateEventDefinition.getAttributeValue("activityRef");
        Activity referencedActivity = compensateEventDefinition.getActivity();
        if (referencedActivity == null) {
            if (activityRef != null && !activityRef.isEmpty()) {
                validationResultCollector.addError(0, String.format("The referenced compensation activity '%s' doesn't exist", activityRef));
            }
        } else {
            CompensationEventDefinitionValidator.validateReferencedActivity(compensateEventDefinition, validationResultCollector, referencedActivity);
        }
    }

    private static void validateReferencedActivity(CompensateEventDefinition compensateEventDefinition, ValidationResultCollector validationResultCollector, Activity referencedActivity) {
        if (!CompensationEventDefinitionValidator.isValidCompensationActivity(referencedActivity)) {
            validationResultCollector.addError(0, String.format("The referenced compensation activity '%s' must have either a compensation boundary event or be a subprocess", referencedActivity.getId()));
        }
        if (!CompensationEventDefinitionValidator.hasCompensationActivityInSameScope(compensateEventDefinition, referencedActivity)) {
            validationResultCollector.addError(0, String.format("The referenced compensation activity '%s' must be in the same scope as the compensation throw event", referencedActivity.getId()));
        }
    }

    private static boolean isValidCompensationActivity(Activity activity) {
        return CompensationEventDefinitionValidator.hasCompensationBoundaryEvent(activity) || CompensationEventDefinitionValidator.isSubprocess(activity);
    }

    private static boolean hasCompensationBoundaryEvent(Activity activity) {
        return ModelUtil.getEventDefinitionsForBoundaryEvents(activity).stream().anyMatch(CompensateEventDefinition.class::isInstance);
    }

    private static boolean isSubprocess(Activity activity) {
        if (activity instanceof SubProcess) {
            return !((SubProcess)activity).triggeredByEvent();
        }
        return false;
    }

    private static boolean hasCompensationActivityInSameScope(CompensateEventDefinition compensateEventDefinition, Activity referencedActivity) {
        BpmnModelElementInstance compensationEventScope = compensateEventDefinition.getScope();
        return referencedActivity.getScope() == compensationEventScope || CompensationEventDefinitionValidator.isEventSubprocess(compensationEventScope) && referencedActivity.getScope() == compensationEventScope.getScope();
    }

    private static boolean isEventSubprocess(BpmnModelElementInstance elementInstance) {
        if (elementInstance instanceof SubProcess) {
            return ((SubProcess)elementInstance).triggeredByEvent();
        }
        return false;
    }
}

