/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.auth;

import io.camunda.zeebe.auth.api.TenantAuthorizationChecker;
import io.camunda.zeebe.auth.impl.TenantAuthorizationCheckerImpl;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class TenantAuthorizationCheckerTest {
    private static TenantAuthorizationChecker accessChecker;

    @BeforeAll
    public static void setUp() {
        accessChecker = new TenantAuthorizationCheckerImpl(List.of("tenant-1", "tenant-2", "tenant-3"));
    }

    @Test
    public void shouldConfirmSingleTenantAccess() {
        String tenantId = "tenant-1";
        Assertions.assertThat((Boolean)accessChecker.isAuthorized("tenant-1")).isTrue();
    }

    @Test
    public void shouldRejectUnauthorizedTenant() {
        String falseTenantId = "false-tenant";
        Assertions.assertThat((Boolean)accessChecker.isAuthorized("false-tenant")).isFalse();
    }

    @Test
    public void shouldConfirmMultiTenantAccess() {
        List<String> tenantIds = List.of("tenant-1", "tenant-2");
        Assertions.assertThat((Boolean)accessChecker.isFullyAuthorized(tenantIds)).isTrue();
    }

    @Test
    public void shouldRejectMultiTenantAccessWithUnauthorizedTenant() {
        List<String> tenantIds = List.of("tenant-1", "tenant-2", "false-tenant");
        Assertions.assertThat((Boolean)accessChecker.isFullyAuthorized(tenantIds)).isFalse();
    }
}

