/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.auth;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.interfaces.Claim;
import io.camunda.zeebe.auth.impl.Authorization;
import io.camunda.zeebe.auth.impl.JwtAuthorizationDecoder;
import io.camunda.zeebe.auth.impl.JwtAuthorizationEncoder;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class JwtAuthorizationTest {
    @Test
    public void shouldEncodeJwtTokenWithDefaultClaims() {
        JwtAuthorizationEncoder encoder = Authorization.jwtEncoder();
        String jwtToken = encoder.encode();
        Map claims = JWT.decode((String)jwtToken).getClaims();
        this.assertDefaultClaims(claims);
    }

    @Test
    public void shouldEncodeJwtTokenWithAuthorizedTenants() {
        List<String> authorizedTenants = List.of("tenant-1", "tenant-2", "tenant-3");
        JwtAuthorizationEncoder encoder = Authorization.jwtEncoder().withClaim("authorized_tenants", authorizedTenants);
        String jwtToken = encoder.encode();
        Map claims = JWT.decode((String)jwtToken).getClaims();
        this.assertDefaultClaims(claims);
        Assertions.assertThat((Map)claims).containsKey((Object)"authorized_tenants");
        List authorizedTenantClaim = (List)((Claim)claims.get("authorized_tenants")).as(List.class);
        Assertions.assertThat((List)authorizedTenantClaim).containsExactlyElementsOf(authorizedTenants);
    }

    @Test
    public void shouldValidateAndDecodeJwtTokenWithDefaultClaims() {
        String jwtToken = JWT.create().withIssuer("zeebe-gateway").withAudience(new String[]{"zeebe-broker"}).withSubject("zeebe-client").sign(Algorithm.none());
        JwtAuthorizationDecoder decoder = Authorization.jwtDecoder((String)jwtToken);
        Map claims = decoder.build().getClaims();
        this.assertDefaultClaims(claims);
    }

    @Test
    public void shouldValidateAndDecodeJwtTokenWithAuthorizedTenantsClaim() {
        List<String> authorizedTenants = List.of("tenant-1", "tenant-2", "tenant-3");
        String jwtToken = JWT.create().withIssuer("zeebe-gateway").withAudience(new String[]{"zeebe-broker"}).withSubject("zeebe-client").withClaim("authorized_tenants", authorizedTenants).sign(Algorithm.none());
        JwtAuthorizationDecoder decoder = Authorization.jwtDecoder((String)jwtToken).withClaim("authorized_tenants");
        Map claims = decoder.build().getClaims();
        this.assertDefaultClaims(claims);
        List authorizedTenantClaim = (List)((Claim)claims.get("authorized_tenants")).as(List.class);
        Assertions.assertThat((List)authorizedTenantClaim).containsExactlyElementsOf(authorizedTenants);
    }

    @Test
    public void shouldFailJwtTokenValidationWithNoAuthorizedTenants() {
        String jwtToken = JWT.create().withIssuer("zeebe-gateway").withAudience(new String[]{"zeebe-broker"}).withSubject("zeebe-client").sign(Algorithm.none());
        JwtAuthorizationDecoder decoder = Authorization.jwtDecoder((String)jwtToken).withClaim("authorized_tenants");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> decoder.decode()).isInstanceOf(UnrecoverableException.class)).hasMessage("Authorization data unavailable: The Claim 'authorized_tenants' is not present in the JWT.");
    }

    @Test
    public void shouldFailJwtTokenDecodingWithInvalidJwtToken() {
        String invalidJwtToken = "invalid.jwt.token";
        JwtAuthorizationDecoder decoder = Authorization.jwtDecoder((String)"invalid.jwt.token");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> decoder.decode()).isInstanceOf(UnrecoverableException.class)).hasMessageContaining("Authorization data unavailable").hasMessageContaining("doesn't have a valid JSON format");
    }

    @Test
    public void shouldFailJwtTokenDecodingWithoutJwtToken() {
        JwtAuthorizationDecoder decoder = Authorization.jwtDecoder(null).withClaim("authorized_tenants");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> decoder.decode()).isInstanceOf(UnrecoverableException.class)).hasMessage("Authorization data unavailable: The token is null.");
    }

    @Test
    public void shouldNotFailVerificationForFutureIssuedAt() {
        String jwtToken = JWT.create().withIssuer("zeebe-gateway").withAudience(new String[]{"zeebe-broker"}).withSubject("zeebe-client").withClaim("authorized_tenants", List.of()).withIssuedAt(Instant.now().plus(10L, ChronoUnit.MINUTES)).sign(Algorithm.none());
        Authorization.jwtDecoder((String)jwtToken).withClaim("authorized_tenants").build();
    }

    private void assertDefaultClaims(Map<String, Claim> claims) {
        Assertions.assertThat(claims).containsKey((Object)"iss");
        Assertions.assertThat((String)((String)claims.get("iss").as(String.class))).isEqualTo("zeebe-gateway");
        Assertions.assertThat(claims).containsKey((Object)"aud");
        Assertions.assertThat((String)((String)claims.get("aud").as(String.class))).isEqualTo("zeebe-broker");
        Assertions.assertThat(claims).containsKey((Object)"sub");
        Assertions.assertThat((String)((String)claims.get("sub").as(String.class))).isEqualTo("zeebe-client");
    }
}

