/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.auth.impl;

import io.camunda.zeebe.auth.api.TenantAuthorizationChecker;
import java.util.List;
import java.util.Map;

public class TenantAuthorizationCheckerImpl
implements TenantAuthorizationChecker {
    private final List<String> authorizedTenants;

    public TenantAuthorizationCheckerImpl(List<String> authorizedTenants) {
        this.authorizedTenants = authorizedTenants;
    }

    @Override
    public Boolean isAuthorized(String tenantId) {
        return this.authorizedTenants.contains(tenantId);
    }

    @Override
    public Boolean isFullyAuthorized(List<String> tenantIds) {
        return this.authorizedTenants.containsAll(tenantIds);
    }

    public static TenantAuthorizationChecker fromAuthorizationMap(Map<String, Object> authMap) {
        List<String> authorizedTenants = authMap.getOrDefault("authorized_tenants", List.of());
        return new TenantAuthorizationCheckerImpl(authorizedTenants);
    }
}

