/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.sso;

import com.auth0.AuthenticationController;
import io.camunda.tasklist.webapp.security.BaseWebConfigurer;
import io.camunda.tasklist.webapp.security.TasklistURIs;
import io.camunda.tasklist.webapp.security.oauth.OAuth2WebConfigurer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

@Profile(value={"sso-auth"})
@Configuration
@EnableWebSecurity
@Component(value="webSecurityConfig")
public class SSOWebSecurityConfig
extends BaseWebConfigurer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SSOWebSecurityConfig.class);
    @Autowired
    private OAuth2WebConfigurer oAuth2WebConfigurer;

    @Bean
    public AuthenticationController authenticationController() {
        return AuthenticationController.newBuilder((String)this.tasklistProperties.getAuth0().getDomain(), (String)this.tasklistProperties.getAuth0().getClientId(), (String)this.tasklistProperties.getAuth0().getClientSecret()).build();
    }

    @Override
    protected void applyOAuth2Settings(HttpSecurity http) throws Exception {
        this.oAuth2WebConfigurer.configure(http);
    }

    @Override
    protected void applySecurityFilterSettings(HttpSecurity http, HandlerMappingIntrospector introspector) throws Exception {
        if (this.tasklistProperties.isCsrfPreventionEnabled()) {
            this.logger.info("CSRF Protection Enabled");
            this.configureCSRF(http);
        } else {
            http.csrf(csrf -> csrf.disable());
        }
        http.authorizeRequests(authorize -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)authorize.requestMatchers(TasklistURIs.getAuthWhitelist(introspector))).permitAll().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/graphql"), AntPathRequestMatcher.antMatcher((String)"/v*/**"), AntPathRequestMatcher.antMatcher((String)"/error")})).authenticated().requestMatchers(new RequestMatcher[]{AntPathRequestMatcher.antMatcher((String)"/tasklist")})).authenticated()).exceptionHandling(handling -> handling.authenticationEntryPoint(this::authenticationEntry));
    }

    protected void authenticationEntry(HttpServletRequest req, HttpServletResponse res, AuthenticationException ex) throws IOException {
        Object requestedUrl = req.getRequestURI();
        if (req.getQueryString() != null && !req.getQueryString().isEmpty()) {
            requestedUrl = (String)requestedUrl + "?" + req.getQueryString();
        }
        if (StringUtils.containsAny((CharSequence)((String)requestedUrl).toLowerCase(), (CharSequence[])new CharSequence[]{"/graphql", "/v1/"})) {
            req.getSession().invalidate();
            SSOWebSecurityConfig.sendJSONErrorMessage(res, ex.getMessage());
        } else {
            LOGGER.debug("Try to access protected resource {}. Save it for later redirect", requestedUrl);
            req.getSession().setAttribute("requestedUrl", requestedUrl);
            res.sendRedirect(req.getContextPath() + "/api/login");
        }
    }
}

