/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security.se.store;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.tasklist.data.conditionals.ElasticSearchCondition;
import io.camunda.tasklist.entities.UserEntity;
import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.schema.indices.UserIndex;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.webapp.rest.exception.NotFoundApiException;
import io.camunda.tasklist.webapp.security.se.store.UserStore;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptType;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.ScriptSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Component;

@Component
@Profile(value={"!sso-auth & !identity-auth"})
@DependsOn(value={"tasklistSchemaStartup"})
@Conditional(value={ElasticSearchCondition.class})
public class UserStoreElasticSearch
implements UserStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserStoreElasticSearch.class);
    private static final XContentType XCONTENT_TYPE = XContentType.JSON;
    @Autowired
    private UserIndex userIndex;
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="tasklistObjectMapper")
    private ObjectMapper objectMapper;

    @Override
    public UserEntity getByUserId(String userId) {
        SearchRequest searchRequest = new SearchRequest(new String[]{this.userIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"userId", (String)userId)));
        try {
            SearchResponse response = this.esClient.search(searchRequest, RequestOptions.DEFAULT);
            if (response.getHits().getTotalHits().value == 1L) {
                return (UserEntity)ElasticsearchUtil.fromSearchHit((String)response.getHits().getHits()[0].getSourceAsString(), (ObjectMapper)this.objectMapper, UserEntity.class);
            }
            if (response.getHits().getTotalHits().value > 1L) {
                throw new NotFoundApiException(String.format("Could not find unique user with userId '%s'.", userId));
            }
            throw new NotFoundApiException(String.format("Could not find user with userId '%s'.", userId));
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining the user: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    @Override
    public void create(UserEntity user) {
        try {
            IndexRequest request = new IndexRequest(this.userIndex.getFullQualifiedName()).id(user.getId()).source(this.userEntityToJSONString(user), XCONTENT_TYPE);
            this.esClient.index(request, RequestOptions.DEFAULT);
        }
        catch (Exception e) {
            LOGGER.error("Could not create user with user id {}", (Object)user.getUserId(), (Object)e);
        }
    }

    @Override
    public List<UserEntity> getUsersByUserIds(List<String> userIds) {
        ConstantScoreQueryBuilder esQuery = QueryBuilders.constantScoreQuery((QueryBuilder)QueryBuilders.idsQuery().addIds((String[])userIds.toArray(String[]::new)));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.userIndex.getAlias()}).source(new SearchSourceBuilder().query((QueryBuilder)esQuery).sort(SortBuilders.scriptSort((Script)this.getScript(userIds), (ScriptSortBuilder.ScriptSortType)ScriptSortBuilder.ScriptSortType.NUMBER).order(SortOrder.ASC)).fetchSource(new String[]{"userId", "displayName"}, null));
        try {
            return ElasticsearchUtil.scroll((SearchRequest)searchRequest, UserEntity.class, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient);
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining users: %s", e.getMessage());
            throw new TasklistRuntimeException(message, (Throwable)e);
        }
    }

    private Script getScript(List<String> userIds) {
        String scriptCode = String.format("def userIdsCount = params.userIds.size();def userId = doc['%s'].value;def foundIdx = params.userIds.indexOf(userId);return foundIdx > -1 ? foundIdx: userIdsCount + 1;", "userId");
        return new Script(ScriptType.INLINE, "painless", scriptCode, Map.of("userIds", userIds));
    }

    protected String userEntityToJSONString(UserEntity aUser) throws JsonProcessingException {
        return this.objectMapper.writeValueAsString((Object)aUser);
    }
}

