/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.security;

import io.camunda.tasklist.webapp.security.Permission;
import io.camunda.tasklist.webapp.security.UserReader;
import java.util.List;
import org.springframework.security.access.expression.SecurityExpressionRoot;
import org.springframework.security.access.expression.method.MethodSecurityExpressionOperations;
import org.springframework.security.core.Authentication;

public class CustomSecurityExpressionRoot
extends SecurityExpressionRoot
implements MethodSecurityExpressionOperations {
    private UserReader userReader;
    private Object filterObject;
    private Object returnObject;
    private Object target;

    public CustomSecurityExpressionRoot(Authentication authentication) {
        super(authentication);
    }

    public boolean hasPermission(String permission) {
        List<Permission> permissions = this.userReader.getCurrentUser().getPermissions();
        return permissions != null && permissions.contains((Object)Permission.fromString(permission));
    }

    public void setFilterObject(Object filterObject) {
        this.filterObject = filterObject;
    }

    public Object getFilterObject() {
        return this.filterObject;
    }

    public void setReturnObject(Object returnObject) {
        this.returnObject = returnObject;
    }

    public Object getReturnObject() {
        return this.returnObject;
    }

    public Object getThis() {
        return this.target;
    }

    public void setThis(Object target) {
        this.target = target;
    }

    public CustomSecurityExpressionRoot setUserReader(UserReader userReader) {
        this.userReader = userReader;
        return this;
    }
}

