/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.graphql.resolvers;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLNonNull;
import graphql.kickstart.annotations.GraphQLQueryResolver;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.SelectedField;
import io.camunda.tasklist.store.FormStore;
import io.camunda.tasklist.store.ProcessStore;
import io.camunda.tasklist.util.SpringContextHolder;
import io.camunda.tasklist.webapp.graphql.entity.FormDTO;
import io.camunda.tasklist.webapp.graphql.entity.ProcessDTO;
import io.camunda.tasklist.webapp.graphql.entity.TaskDTO;
import io.camunda.tasklist.webapp.graphql.entity.TaskQueryDTO;
import io.camunda.tasklist.webapp.graphql.entity.UserDTO;
import io.camunda.tasklist.webapp.graphql.entity.VariableDTO;
import io.camunda.tasklist.webapp.security.UserReader;
import io.camunda.tasklist.webapp.security.identity.IdentityAuthorizationService;
import io.camunda.tasklist.webapp.service.TaskService;
import io.camunda.tasklist.webapp.service.VariableService;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@GraphQLQueryResolver
public class Queries {
    @GraphQLField
    @GraphQLNonNull
    public static UserDTO currentUser() {
        return ((UserReader)SpringContextHolder.getBean(UserReader.class)).getCurrentUser();
    }

    @GraphQLField
    public static List<TaskDTO> tasks(TaskQueryDTO query) {
        return ((TaskService)SpringContextHolder.getBean(TaskService.class)).getTasks(query);
    }

    @GraphQLField
    @GraphQLNonNull
    public static TaskDTO task(String id) {
        return ((TaskService)SpringContextHolder.getBean(TaskService.class)).getTask(id);
    }

    @GraphQLField
    public static List<VariableDTO> variables(String taskId, List<String> variableNames, DataFetchingEnvironment env) {
        return ((VariableService)SpringContextHolder.getBean(VariableService.class)).getVariables(taskId, variableNames, Queries.getFieldNames(env));
    }

    @GraphQLField
    @GraphQLNonNull
    public static VariableDTO variable(String id, DataFetchingEnvironment env) {
        return ((VariableService)SpringContextHolder.getBean(VariableService.class)).getVariable(id, Queries.getFieldNames(env));
    }

    @GraphQLField
    public static FormDTO form(String id, String processDefinitionId) {
        return FormDTO.createFrom(((FormStore)SpringContextHolder.getBean(FormStore.class)).getForm(id, processDefinitionId, null));
    }

    @GraphQLField
    public static List<ProcessDTO> processes(String search) {
        return ((ProcessStore)SpringContextHolder.getBean(ProcessStore.class)).getProcesses(search, ((IdentityAuthorizationService)SpringContextHolder.getBean(IdentityAuthorizationService.class)).getProcessDefinitionsFromAuthorization(), "<default>", null).stream().map(ProcessDTO::createFrom).collect(Collectors.toList());
    }

    private static Set<String> getFieldNames(DataFetchingEnvironment env) {
        return env.getSelectionSet().getFields().stream().map(SelectedField::getName).collect(Collectors.toSet());
    }
}

