/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.graphql.error;

import graphql.ExceptionWhileDataFetching;
import graphql.GraphQLError;
import graphql.GraphqlErrorBuilder;
import graphql.kickstart.execution.error.GraphQLErrorHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CustomGraphQLErrorHandler
implements GraphQLErrorHandler {
    public List<GraphQLError> processErrors(List<GraphQLError> list) {
        return list.stream().map(this::getNested).toList();
    }

    private GraphQLError getNested(GraphQLError error) {
        if (error instanceof ExceptionWhileDataFetching) {
            ExceptionWhileDataFetching exceptionError = (ExceptionWhileDataFetching)error;
            Throwable exception = exceptionError.getException();
            if (exception instanceof GraphQLError) {
                return (GraphQLError)exception;
            }
            if (exception.getCause() != null && exception.getCause() instanceof InvocationTargetException) {
                InvocationTargetException ite = (InvocationTargetException)exception.getCause();
                if (ite.getTargetException() instanceof GraphQLError) {
                    return (GraphQLError)ite.getTargetException();
                }
                if (ite.getTargetException() != null) {
                    return GraphqlErrorBuilder.newError().message(ite.getTargetException().getMessage(), new Object[0]).build();
                }
            }
        }
        return error;
    }
}

