/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.cache;

import io.camunda.tasklist.entities.ProcessEntity;
import io.camunda.tasklist.entities.ProcessFlowNodeEntity;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class ProcessCacheEntity {
    private String name;
    private Map<String, String> flowNodeNames = new HashMap<String, String>();

    public String getName() {
        return this.name;
    }

    public ProcessCacheEntity setName(String name) {
        this.name = name;
        return this;
    }

    public Map<String, String> getFlowNodeNames() {
        return this.flowNodeNames;
    }

    public ProcessCacheEntity setFlowNodeNames(Map<String, String> flowNodeNames) {
        this.flowNodeNames = flowNodeNames;
        return this;
    }

    public static ProcessCacheEntity createFrom(ProcessEntity processEntity) {
        return new ProcessCacheEntity().setName(processEntity.getName()).setFlowNodeNames(processEntity.getFlowNodes().stream().collect(Collectors.toMap(ProcessFlowNodeEntity::getId, ProcessFlowNodeEntity::getName)));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessCacheEntity that = (ProcessCacheEntity)o;
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.flowNodeNames != null ? this.flowNodeNames.equals(that.flowNodeNames) : that.flowNodeNames == null;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.flowNodeNames);
    }
}

