/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.backup;

import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Metadata {
    public static final String SNAPSHOT_NAME_PREFIX = "camunda_tasklist_";
    private static final String SNAPSHOT_NAME_PATTERN = "{prefix}{version}_part_{index}_of_{count}";
    private static final String SNAPSHOT_NAME_PREFIX_PATTERN = "camunda_tasklist_{backupId}_";
    private static final Pattern BACKUPID_PATTERN = Pattern.compile("camunda_tasklist_(\\d*)_.*");
    private Long backupId;
    private String version;
    private Integer partNo;
    private Integer partCount;

    public Long getBackupId() {
        return this.backupId;
    }

    public Metadata setBackupId(Long backupId) {
        this.backupId = backupId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Metadata setVersion(String version) {
        this.version = version;
        return this;
    }

    public Integer getPartNo() {
        return this.partNo;
    }

    public Metadata setPartNo(Integer partNo) {
        this.partNo = partNo;
        return this;
    }

    public Integer getPartCount() {
        return this.partCount;
    }

    public Metadata setPartCount(Integer partCount) {
        this.partCount = partCount;
        return this;
    }

    public String buildSnapshotName() {
        return SNAPSHOT_NAME_PATTERN.replace("{prefix}", Metadata.buildSnapshotNamePrefix(this.backupId)).replace("{version}", this.version).replace("{index}", "" + this.partNo).replace("{count}", "" + this.partCount);
    }

    public static String buildSnapshotNamePrefix(Long backupId) {
        return SNAPSHOT_NAME_PREFIX_PATTERN.replace("{backupId}", String.valueOf(backupId));
    }

    public static Long extractBackupIdFromSnapshotName(String snapshotName) {
        Matcher matcher = BACKUPID_PATTERN.matcher(snapshotName);
        if (matcher.matches()) {
            return Long.valueOf(matcher.group(1));
        }
        throw new TasklistRuntimeException("Unable to extract backupId. Snapshot name: " + snapshotName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.version, metadata.version) && Objects.equals(this.partNo, metadata.partNo) && Objects.equals(this.partCount, metadata.partCount);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.partNo, this.partCount);
    }
}

