/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.es.backup;

import io.camunda.tasklist.exceptions.TasklistRuntimeException;
import io.camunda.tasklist.property.TasklistProperties;
import io.camunda.tasklist.schema.backup.BackupPriority;
import io.camunda.tasklist.schema.backup.Prio1Backup;
import io.camunda.tasklist.schema.backup.Prio2Backup;
import io.camunda.tasklist.schema.backup.Prio3Backup;
import io.camunda.tasklist.schema.backup.Prio4Backup;
import io.camunda.tasklist.schema.indices.IndexDescriptor;
import io.camunda.tasklist.schema.templates.TemplateDescriptor;
import io.camunda.tasklist.webapp.management.dto.GetBackupStateResponseDto;
import io.camunda.tasklist.webapp.management.dto.TakeBackupRequestDto;
import io.camunda.tasklist.webapp.management.dto.TakeBackupResponseDto;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BackupManager {
    @Autowired
    private List<Prio1Backup> prio1BackupIndices;
    @Autowired
    private List<Prio2Backup> prio2BackupTemplates;
    @Autowired
    private List<Prio3Backup> prio3BackupTemplates;
    @Autowired
    private List<Prio4Backup> prio4BackupIndices;
    @Autowired
    private TasklistProperties tasklistProperties;
    private String[][] indexPatternsOrdered;

    public abstract void deleteBackup(Long var1);

    public abstract TakeBackupResponseDto takeBackup(TakeBackupRequestDto var1);

    public abstract GetBackupStateResponseDto getBackupState(Long var1);

    public abstract List<GetBackupStateResponseDto> getBackups();

    protected String getFullQualifiedName(BackupPriority index) {
        if (index instanceof IndexDescriptor) {
            return ((IndexDescriptor)index).getFullQualifiedName();
        }
        if (index instanceof TemplateDescriptor) {
            return ((TemplateDescriptor)index).getFullQualifiedName();
        }
        throw new TasklistRuntimeException("Can't find out index name for backup.");
    }

    protected String[][] getIndexPatternsOrdered() {
        if (this.indexPatternsOrdered == null) {
            this.indexPatternsOrdered = new String[][]{(String[])this.prio1BackupIndices.stream().map(this::getFullQualifiedName).toArray(String[]::new), (String[])this.prio2BackupTemplates.stream().map(this::getFullQualifiedName).toArray(String[]::new), (String[])this.prio2BackupTemplates.stream().filter(i -> i instanceof TemplateDescriptor).map(index -> new String[]{this.getFullQualifiedName((BackupPriority)index) + "*", "-" + this.getFullQualifiedName((BackupPriority)index)}).flatMap(x -> Arrays.stream(x)).toArray(String[]::new), (String[])this.prio3BackupTemplates.stream().map(this::getFullQualifiedName).toArray(String[]::new), (String[])this.prio3BackupTemplates.stream().filter(i -> i instanceof TemplateDescriptor).map(index -> new String[]{this.getFullQualifiedName((BackupPriority)index) + "*", "-" + this.getFullQualifiedName((BackupPriority)index)}).flatMap(Arrays::stream).toArray(String[]::new), (String[])this.prio4BackupIndices.stream().map(this::getFullQualifiedName).toArray(String[]::new)};
        }
        return this.indexPatternsOrdered;
    }

    protected String getRepositoryName() {
        return this.tasklistProperties.getBackup().getRepositoryName();
    }

    protected String getCurrentTasklistVersion() {
        return this.tasklistProperties.getVersion().toLowerCase();
    }
}

