/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import io.swagger.v3.oas.annotations.media.Schema;
import java.util.StringJoiner;

@Schema(description="Request params used to assign the task to assignee or current user.")
public class TaskAssignRequest {
    @Schema(description="When using a JWT token, the assignee parameter is NOT optional when called directly from the API.\nThe system will not be able to detect the assignee from the JWT token, therefore the assignee parameter needs to be\nexplicitly passed in this instance.")
    private String assignee;
    @Schema(description="When `true` the task that is already assigned may be assigned again. Otherwise the task\nmust be first unassigned and only then assigned again.", defaultValue="true")
    private Boolean allowOverrideAssignment = true;

    public String getAssignee() {
        return this.assignee;
    }

    public TaskAssignRequest setAssignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    public boolean isAllowOverrideAssignment() {
        return this.allowOverrideAssignment;
    }

    public TaskAssignRequest setAllowOverrideAssignment(boolean allowOverrideAssignment) {
        this.allowOverrideAssignment = allowOverrideAssignment;
        return this;
    }

    public String toString() {
        return new StringJoiner(", ", TaskAssignRequest.class.getSimpleName() + "[", "]").add("assignee='" + this.assignee + "'").add("allowOverrideAssignment=" + this.allowOverrideAssignment).toString();
    }
}

