/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.webapp.api.rest.v1.entities;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.camunda.tasklist.entities.FormEntity;
import io.camunda.tasklist.entities.ProcessEntity;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import java.util.StringJoiner;

public class FormResponse {
    @Schema(description="The unique identifier of the embedded form within one process.")
    private String id;
    @Schema(description="Reference to process definition (renamed equivalent of `Form.processDefinitionId` field).")
    private String processDefinitionKey;
    @Schema(description="The title of the form.")
    private String title;
    @Schema(description="The form content.")
    private String schema;
    @Schema(description="The version field is null in the case of an embedded form, while it represents the deployed form's version in other scenarios.", format="int64")
    private Long version;
    @Schema(description="The tenant ID associated with the form.")
    private String tenantId;
    @Schema(description="Indicates whether the deployed form is deleted or not on Zeebe. This field is false by default, in the case of an embedded form.")
    private Boolean isDeleted;

    public String getId() {
        return this.id;
    }

    public FormResponse setId(String id) {
        this.id = id;
        return this;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public FormResponse setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getTitle() {
        return this.title;
    }

    public FormResponse setTitle(String processName) {
        this.title = processName;
        return this;
    }

    public String getSchema() {
        return this.schema;
    }

    public FormResponse setSchema(String schema) {
        this.schema = schema;
        return this;
    }

    public Long getVersion() {
        return this.version;
    }

    public FormResponse setVersion(Long version) {
        this.version = version;
        return this;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public FormResponse setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public FormResponse setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
        return this;
    }

    public String toString() {
        return new StringJoiner(", ", FormResponse.class.getSimpleName() + "[", "]").add("id='" + this.id + "'").add("processDefinitionKey='" + this.processDefinitionKey + "'").add("title='" + this.title + "'").add("schema='" + this.schema + "'").add("version='" + this.version + "'").add("tenantId='" + this.tenantId + "'").add("isDeleted='" + this.isDeleted + "'").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormResponse that = (FormResponse)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.title, that.title) && Objects.equals(this.schema, that.schema) && Objects.equals(this.version, that.version) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.isDeleted, that.isDeleted);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.processDefinitionKey, this.title, this.schema, this.version, this.tenantId, this.isDeleted);
    }

    public static FormResponse fromFormEntity(FormEntity form) {
        return new FormResponse().setId(form.getBpmnId()).setProcessDefinitionKey(form.getProcessDefinitionId()).setSchema(form.getSchema()).setVersion(form.getVersion()).setTenantId(form.getTenantId()).setIsDeleted(form.getIsDeleted());
    }

    public static FormResponse fromFormEntity(FormEntity form, ProcessEntity processEntity) {
        return new FormResponse().setId(form.getBpmnId()).setProcessDefinitionKey(form.getProcessDefinitionId()).setTitle(processEntity.getName() != null ? processEntity.getName() : processEntity.getBpmnProcessId()).setSchema(form.getSchema()).setVersion(form.getVersion()).setTenantId(form.getTenantId()).setIsDeleted(form.getIsDeleted());
    }
}

