/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.util;

import io.camunda.tasklist.entities.ProcessFlowNodeEntity;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Component
public class XMLUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLUtil.class);

    private SAXParserFactory getSAXParserFactory() {
        SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
        saxParserFactory.setNamespaceAware(true);
        try {
            saxParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            return saxParserFactory;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Error creating SAXParser: " + e.getMessage(), e);
        }
    }

    public void extractDiagramData(byte[] byteArray, Predicate<String> processIdPredicate, Consumer<String> nameConsumer, Consumer<ProcessFlowNodeEntity> flowNodeConsumer, BiConsumer<String, String> userTaskFormConsumer, Consumer<String> formKeyConsumer, Consumer<String> formIdConsumer, Consumer<Boolean> startedByFormConsumer) {
        SAXParserFactory saxParserFactory = this.getSAXParserFactory();
        ByteArrayInputStream is = new ByteArrayInputStream(byteArray);
        BpmnXmlParserHandler handler = new BpmnXmlParserHandler(processIdPredicate, nameConsumer, flowNodeConsumer, userTaskFormConsumer, formKeyConsumer, formIdConsumer, startedByFormConsumer);
        try {
            saxParserFactory.newSAXParser().parse((InputStream)is, (DefaultHandler)handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.warn("Unable to parse diagram: " + e.getMessage(), (Throwable)e);
        }
    }

    public static class BpmnXmlParserHandler
    extends DefaultHandler {
        private final Predicate<String> processIdPredicate;
        private final Consumer<String> nameConsumer;
        private final Consumer<ProcessFlowNodeEntity> flowNodeConsumer;
        private final BiConsumer<String, String> userTaskFormConsumer;
        private final Consumer<String> formKeyConsumer;
        private final Consumer<String> formIdConsumer;
        private final Consumer<Boolean> startedByFormConsumer;
        private boolean isUserTaskForm = false;
        private boolean isStartEvent = false;
        private boolean isCurrentProcess = false;
        private String userTaskFormId;
        private StringBuilder userTaskFormJson = new StringBuilder();

        public BpmnXmlParserHandler(Predicate<String> processIdPredicate, Consumer<String> nameConsumer, Consumer<ProcessFlowNodeEntity> flowNodeConsumer, BiConsumer<String, String> userTaskFormConsumer, Consumer<String> formKeyConsumer, Consumer<String> formIdConsumer, Consumer<Boolean> startedByFormConsumer) {
            this.processIdPredicate = processIdPredicate;
            this.nameConsumer = nameConsumer;
            this.flowNodeConsumer = flowNodeConsumer;
            this.userTaskFormConsumer = userTaskFormConsumer;
            this.formKeyConsumer = formKeyConsumer;
            this.formIdConsumer = formIdConsumer;
            this.startedByFormConsumer = startedByFormConsumer;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if ("process".equalsIgnoreCase(localName)) {
                if (this.processIdPredicate.test(attributes.getValue("id"))) {
                    this.isCurrentProcess = true;
                    if (attributes.getValue("name") != null) {
                        this.nameConsumer.accept(attributes.getValue("name"));
                    }
                }
            } else if (this.isCurrentProcess) {
                if ("userTask".equalsIgnoreCase(localName)) {
                    if (attributes.getValue("name") != null) {
                        ProcessFlowNodeEntity flowNodeEntity = new ProcessFlowNodeEntity(attributes.getValue("id"), attributes.getValue("name"));
                        this.flowNodeConsumer.accept(flowNodeEntity);
                    }
                } else if ("userTaskForm".equalsIgnoreCase(localName)) {
                    this.isUserTaskForm = true;
                    if (attributes.getValue("id") != null) {
                        this.userTaskFormId = attributes.getValue("id");
                    }
                } else if ("startEvent".equalsIgnoreCase(localName)) {
                    this.isStartEvent = true;
                } else if (this.isStartEvent) {
                    if ("formDefinition".equalsIgnoreCase(localName)) {
                        if (attributes.getValue("formKey") != null) {
                            this.formKeyConsumer.accept(attributes.getValue("formKey"));
                        }
                        if (attributes.getValue("formId") != null) {
                            this.formIdConsumer.accept(attributes.getValue("formId"));
                        }
                    } else if ("property".equalsIgnoreCase(localName)) {
                        String name = attributes.getValue("name");
                        String value = attributes.getValue("value");
                        if ("publicAccess".equalsIgnoreCase(name) && "true".equalsIgnoreCase(value)) {
                            this.startedByFormConsumer.accept(true);
                        }
                    }
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (this.isCurrentProcess) {
                if ("process".equalsIgnoreCase(localName)) {
                    this.isCurrentProcess = false;
                } else if ("userTaskForm".equalsIgnoreCase(localName)) {
                    this.userTaskFormConsumer.accept(this.userTaskFormId, this.userTaskFormJson.toString());
                    this.isUserTaskForm = false;
                    this.userTaskFormJson = new StringBuilder();
                } else if ("startEvent".equalsIgnoreCase(localName)) {
                    this.isStartEvent = false;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            if (this.isUserTaskForm) {
                this.userTaskFormJson.append(new String(ch, start, length));
            }
        }
    }
}

