/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.os;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.util.OpenSearchUtil;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.ImportBatchProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.opensearch.client.opensearch.OpenSearchClient;
import org.opensearch.client.opensearch.core.BulkRequest;
import org.opensearch.client.opensearch.core.bulk.BulkOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractImportBatchProcessorOpenSearch
implements ImportBatchProcessor {
    @Qualifier(value="tasklistOsClient")
    @Autowired
    private OpenSearchClient osClient;
    @Autowired
    private Metrics metrics;

    @Override
    public void performImport(ImportBatch importBatch) throws PersistenceException {
        ArrayList<BulkOperation> operations = new ArrayList<BulkOperation>();
        this.processZeebeRecords(importBatch, operations);
        try {
            this.withTimer(() -> {
                OpenSearchUtil.processBulkRequest((OpenSearchClient)this.osClient, (BulkRequest)new BulkRequest.Builder().operations(operations).build());
                return null;
            });
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void withTimer(Callable<Void> callable) throws Exception {
        this.metrics.getTimer("tasklist.import.index.query", new String[0]).recordCallable(callable);
    }

    protected abstract void processZeebeRecords(ImportBatch var1, List<BulkOperation> var2) throws PersistenceException;
}

