/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.tasklist.zeebeimport.es;

import io.camunda.tasklist.Metrics;
import io.camunda.tasklist.exceptions.PersistenceException;
import io.camunda.tasklist.util.ElasticsearchUtil;
import io.camunda.tasklist.zeebeimport.ImportBatch;
import io.camunda.tasklist.zeebeimport.ImportBatchProcessor;
import java.util.concurrent.Callable;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractImportBatchProcessorElasticSearch
implements ImportBatchProcessor {
    @Autowired
    @Qualifier(value="tasklistEsClient")
    private RestHighLevelClient esClient;
    @Autowired
    private Metrics metrics;

    @Override
    public void performImport(ImportBatch importBatchElasticSearch) throws PersistenceException {
        BulkRequest bulkRequest = new BulkRequest();
        this.processZeebeRecords(importBatchElasticSearch, bulkRequest);
        try {
            this.withTimer(() -> {
                ElasticsearchUtil.processBulkRequest((RestHighLevelClient)this.esClient, (BulkRequest)bulkRequest);
                return null;
            });
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    private void withTimer(Callable<Void> callable) throws Exception {
        this.metrics.getTimer("tasklist.import.index.query", new String[0]).recordCallable(callable);
    }

    protected abstract void processZeebeRecords(ImportBatch var1, BulkRequest var2) throws PersistenceException;
}

