/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties;

import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.boot.env.YamlPropertySourceLoader;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class PropertiesPostProcessor
implements EnvironmentPostProcessor {
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            CamundaClientProperties.ClientMode clientMode = (CamundaClientProperties.ClientMode)((Object)environment.getProperty("camunda.client.mode", CamundaClientProperties.ClientMode.class));
            if (clientMode == null) {
                return;
            }
            YamlPropertySourceLoader loader = new YamlPropertySourceLoader();
            String propertiesFile = this.determinePropertiesFile(clientMode);
            ClassPathResource resource = new ClassPathResource(propertiesFile);
            List props = loader.load(propertiesFile, (Resource)resource);
            for (PropertySource prop : props) {
                environment.getPropertySources().addLast(prop);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while post processing camunda properties", e);
        }
    }

    private String determinePropertiesFile(CamundaClientProperties.ClientMode clientMode) {
        switch (clientMode) {
            case oidc: {
                return "application-camunda-oidc.yaml";
            }
            case saas: {
                return "application-camunda-saas.yaml";
            }
            case simple: {
                return "application-camunda-simple.yaml";
            }
        }
        throw new IllegalStateException("Unknown client mode " + String.valueOf((Object)clientMode));
    }
}

