/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.writer;

import java.util.Map;
import java.util.Objects;

public class ProcessInstanceSource {
    private Long processInstanceKey;
    private Long processDefinitionKey;
    private String bpmnProcessId;

    public static ProcessInstanceSource fromSourceMap(Map<String, Object> sourceMap) {
        ProcessInstanceSource processInstanceSource = new ProcessInstanceSource();
        processInstanceSource.setProcessInstanceKey((Long)sourceMap.get("processInstanceKey"));
        processInstanceSource.setProcessDefinitionKey((Long)sourceMap.get("processDefinitionKey"));
        processInstanceSource.setBpmnProcessId((String)sourceMap.get("bpmnProcessId"));
        return processInstanceSource;
    }

    public Long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public ProcessInstanceSource setProcessInstanceKey(Long processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public Long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public ProcessInstanceSource setProcessDefinitionKey(Long processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
        return this;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public ProcessInstanceSource setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.processInstanceKey, this.processDefinitionKey, this.bpmnProcessId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProcessInstanceSource that = (ProcessInstanceSource)o;
        return Objects.equals(this.processInstanceKey, that.processInstanceKey) && Objects.equals(this.processDefinitionKey, that.processDefinitionKey) && Objects.equals(this.bpmnProcessId, that.bpmnProcessId);
    }
}

