/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.ldap;

import io.camunda.operate.property.LdapProperties;
import io.camunda.operate.webapp.security.BaseWebConfigurer;
import io.camunda.operate.webapp.security.ldap.LDAPUserService;
import io.camunda.operate.webapp.security.oauth2.OAuth2WebConfigurer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.core.Authentication;
import org.springframework.security.ldap.authentication.ad.ActiveDirectoryLdapAuthenticationProvider;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Profile(value={"ldap-auth"})
@Configuration
@EnableWebSecurity
@Component(value="webSecurityConfig")
public class LDAPWebSecurityConfig
extends BaseWebConfigurer {
    @Autowired
    protected OAuth2WebConfigurer oAuth2WebConfigurer;
    @Autowired
    private LDAPUserService userService;

    @Override
    protected void applyAuthenticationSettings(AuthenticationManagerBuilder auth) throws Exception {
        LdapProperties ldapConfig = this.operateProperties.getLdap();
        if (StringUtils.hasText((String)ldapConfig.getDomain())) {
            this.setUpActiveDirectoryLDAP(auth, ldapConfig);
        } else {
            this.setupStandardLDAP(auth, ldapConfig);
        }
    }

    @Override
    protected void applyOAuth2Settings(HttpSecurity http) throws Exception {
        this.oAuth2WebConfigurer.configure(http);
    }

    @Override
    protected void logoutSuccessHandler(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        this.userService.cleanUp(authentication);
        super.logoutSuccessHandler(request, response, authentication);
    }

    private void setUpActiveDirectoryLDAP(AuthenticationManagerBuilder auth, LdapProperties ldapConfig) {
        ActiveDirectoryLdapAuthenticationProvider adLDAPProvider = new ActiveDirectoryLdapAuthenticationProvider(ldapConfig.getDomain(), ldapConfig.getUrl(), ldapConfig.getBaseDn());
        if (StringUtils.hasText((String)ldapConfig.getUserSearchFilter())) {
            adLDAPProvider.setSearchFilter(ldapConfig.getUserSearchFilter());
        }
        adLDAPProvider.setConvertSubErrorCodesToExceptions(true);
        auth.authenticationProvider((AuthenticationProvider)adLDAPProvider);
    }

    private void setupStandardLDAP(AuthenticationManagerBuilder auth, LdapProperties ldapConfig) throws Exception {
        auth.ldapAuthentication().userDnPatterns(new String[]{ldapConfig.getUserDnPatterns()}).userSearchFilter(ldapConfig.getUserSearchFilter()).userSearchBase(ldapConfig.getUserSearchBase()).contextSource().url(ldapConfig.getUrl() + ldapConfig.getBaseDn()).managerDn(ldapConfig.getManagerDn()).managerPassword(ldapConfig.getManagerPassword());
    }
}

