/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.ldap;

import io.camunda.operate.property.OperateProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

@Configuration
@Profile(value={"ldap-auth"})
public class LDAPConfig {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OperateProperties operateProperties;

    @Bean
    public LdapTemplate ldapTemplate() {
        try {
            this.getContextSource().getContext(this.operateProperties.getLdap().getManagerDn(), this.operateProperties.getLdap().getManagerPassword());
        }
        catch (Exception e) {
            this.logger.error("Authentication for lookup failed.", (Throwable)e);
        }
        return new LdapTemplate((ContextSource)this.getContextSource());
    }

    @Bean
    public LdapContextSource getContextSource() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.operateProperties.getLdap().getUrl());
        contextSource.setUserDn(this.operateProperties.getLdap().getManagerDn());
        contextSource.setPassword(this.operateProperties.getLdap().getManagerPassword());
        return contextSource;
    }
}

