/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.security.identity;

import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.webapp.security.SecurityContextWrapper;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class IdentityConfigurer {
    @Bean(name={"saasIdentity"})
    @Profile(value={"sso-auth"})
    @ConditionalOnProperty(prefix="camunda.operate", name={"identity.resourcePermissionsEnabled"}, havingValue="true")
    public Identity getSaaSIdentity(OperateProperties operateProperties) {
        return new Identity(new IdentityConfiguration.Builder().withBaseUrl(operateProperties.getIdentity().getBaseUrl()).withType(IdentityConfiguration.Type.AUTH0.name()).build());
    }

    @Bean
    @Profile(value={"sso-auth || identity-auth"})
    public PermissionsService getPermissionsService(OperateProperties operateProperties, SecurityContextWrapper securityContextWrapperComponent) {
        return new PermissionsService(operateProperties, securityContextWrapperComponent);
    }
}

