/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;

public class ModifyProcessInstanceRequestDto {
    private List<Modification> modifications;
    private String processInstanceKey;

    public String getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    public ModifyProcessInstanceRequestDto setProcessInstanceKey(String processInstanceKey) {
        this.processInstanceKey = processInstanceKey;
        return this;
    }

    public List<Modification> getModifications() {
        return this.modifications;
    }

    public ModifyProcessInstanceRequestDto setModifications(List<Modification> modifications) {
        this.modifications = modifications;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.modifications, this.processInstanceKey);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModifyProcessInstanceRequestDto that = (ModifyProcessInstanceRequestDto)o;
        return Objects.equals(this.modifications, that.modifications) && Objects.equals(this.processInstanceKey, that.processInstanceKey);
    }

    public String toString() {
        return "ModifyProcessInstanceRequestDto{modifications=" + String.valueOf(this.modifications) + ", processInstanceKey=" + this.processInstanceKey + "}";
    }

    public static class Modification {
        private Type modification;
        private String fromFlowNodeId;
        private String fromFlowNodeInstanceKey;
        private String toFlowNodeId;
        private Long scopeKey;
        private Long ancestorElementInstanceKey;
        private Integer newTokensCount;
        private Map<String, Object> variables;

        public Type getModification() {
            return this.modification;
        }

        public Modification setModification(Type modification) {
            this.modification = modification;
            return this;
        }

        public String getFromFlowNodeId() {
            return this.fromFlowNodeId;
        }

        public Modification setFromFlowNodeId(String fromFlowNodeId) {
            this.fromFlowNodeId = fromFlowNodeId;
            return this;
        }

        public String getToFlowNodeId() {
            return this.toFlowNodeId;
        }

        public Modification setToFlowNodeId(String toFlowNodeId) {
            this.toFlowNodeId = toFlowNodeId;
            return this;
        }

        public Long getScopeKey() {
            return this.scopeKey;
        }

        public Modification setScopeKey(Long scopeKey) {
            this.scopeKey = scopeKey;
            return this;
        }

        public Map<String, Object> getVariables() {
            return this.variables;
        }

        public Modification setVariables(Map<String, Object> variables) {
            this.variables = variables;
            return this;
        }

        public Map<String, List<Map<String, Object>>> variablesForAddToken() {
            if (this.variables == null || MapUtils.isEmpty(this.variables)) {
                return null;
            }
            HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
            for (String flowNodeId : this.variables.keySet()) {
                List variablesList = (List)this.variables.get(flowNodeId);
                result.put(flowNodeId, variablesList);
            }
            return result;
        }

        public String getFromFlowNodeInstanceKey() {
            return this.fromFlowNodeInstanceKey;
        }

        public Modification setFromFlowNodeInstanceKey(String fromFlowNodeInstanceKey) {
            this.fromFlowNodeInstanceKey = fromFlowNodeInstanceKey;
            return this;
        }

        public Integer getNewTokensCount() {
            return this.newTokensCount;
        }

        public Modification setNewTokensCount(Integer newTokensCount) {
            this.newTokensCount = newTokensCount;
            return this;
        }

        public Long getAncestorElementInstanceKey() {
            return this.ancestorElementInstanceKey;
        }

        public Modification setAncestorElementInstanceKey(Long ancestorElementInstanceKey) {
            this.ancestorElementInstanceKey = ancestorElementInstanceKey;
            return this;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.modification, this.fromFlowNodeId, this.toFlowNodeId, this.scopeKey, this.newTokensCount, this.variables, this.fromFlowNodeInstanceKey, this.ancestorElementInstanceKey});
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Modification that = (Modification)o;
            return this.modification == that.modification && Objects.equals(this.fromFlowNodeId, that.fromFlowNodeId) && Objects.equals(this.toFlowNodeId, that.toFlowNodeId) && Objects.equals(this.scopeKey, that.scopeKey) && Objects.equals(this.newTokensCount, that.newTokensCount) && Objects.equals(this.variables, that.variables) && Objects.equals(this.fromFlowNodeInstanceKey, that.fromFlowNodeInstanceKey) && Objects.equals(this.ancestorElementInstanceKey, that.ancestorElementInstanceKey);
        }

        public String toString() {
            return "Modification{modification=" + String.valueOf((Object)this.modification) + ", fromFlowNodeId='" + this.fromFlowNodeId + "', toFlowNodeId='" + this.toFlowNodeId + "', scopeKey=" + this.scopeKey + ", newTokensCount=" + this.newTokensCount + ", variables=" + String.valueOf(this.variables) + ", fromFlowNodeInstanceKey=" + this.fromFlowNodeInstanceKey + "}, ancestorElementInstanceKey=" + this.ancestorElementInstanceKey + "}";
        }

        public static enum Type {
            ADD_TOKEN,
            CANCEL_TOKEN,
            MOVE_TOKEN,
            ADD_VARIABLE,
            EDIT_VARIABLE;

        }
    }
}

