/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.operation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.webapp.rest.dto.listview.SortValuesWrapper;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;

public class BatchOperationRequestDto {
    private SortValuesWrapper[] searchBefore;
    private SortValuesWrapper[] searchAfter;
    private Integer pageSize;

    public BatchOperationRequestDto() {
    }

    public BatchOperationRequestDto(Integer pageSize, SortValuesWrapper[] searchAfter, SortValuesWrapper[] searchBefore) {
        this.pageSize = pageSize;
        this.searchAfter = searchAfter;
        this.searchBefore = searchBefore;
    }

    @Schema(description="Array of two strings: copy/paste of sortValues field from one of the operations.", example="[\"9223372036854775807\", \"1583836503404\"]")
    public SortValuesWrapper[] getSearchBefore() {
        return this.searchBefore;
    }

    public BatchOperationRequestDto setSearchBefore(SortValuesWrapper[] searchBefore) {
        this.searchBefore = searchBefore;
        return this;
    }

    public Object[] getSearchBefore(ObjectMapper objectMapper) {
        return SortValuesWrapper.convertSortValues(this.searchBefore, objectMapper);
    }

    @Schema(description="Array of two strings: copy/paste of sortValues field from one of the operations.", example="[\"1583836151645\", \"1583836128180\"]")
    public SortValuesWrapper[] getSearchAfter() {
        return this.searchAfter;
    }

    public BatchOperationRequestDto setSearchAfter(SortValuesWrapper[] searchAfter) {
        this.searchAfter = searchAfter;
        return this;
    }

    public Object[] getSearchAfter(ObjectMapper objectMapper) {
        return SortValuesWrapper.convertSortValues(this.searchAfter, objectMapper);
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public BatchOperationRequestDto setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.searchBefore);
        result = 31 * result + Arrays.hashCode(this.searchAfter);
        result = 31 * result + (this.pageSize != null ? this.pageSize.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchOperationRequestDto that = (BatchOperationRequestDto)o;
        if (!Arrays.equals(this.searchBefore, that.searchBefore)) {
            return false;
        }
        if (!Arrays.equals(this.searchAfter, that.searchAfter)) {
            return false;
        }
        return this.pageSize != null ? this.pageSize.equals(that.pageSize) : that.pageSize == null;
    }
}

