/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.operation;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.webapp.rest.dto.listview.SortValuesWrapper;
import io.camunda.operate.webapp.rest.dto.operation.OperationTypeDto;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class BatchOperationDto {
    private String id;
    private String name;
    private OperationTypeDto type;
    private OffsetDateTime startDate;
    private OffsetDateTime endDate;
    private Integer instancesCount = 0;
    private Integer operationsTotalCount = 0;
    private Integer operationsFinishedCount = 0;
    private Integer failedOperationsCount = 0;
    private Integer completedOperationsCount = 0;
    private SortValuesWrapper[] sortValues;

    public static BatchOperationDto createFrom(BatchOperationEntity batchOperationEntity, ObjectMapper objectMapper) {
        return new BatchOperationDto().setId(batchOperationEntity.getId()).setName(batchOperationEntity.getName()).setType(OperationTypeDto.getType(batchOperationEntity.getType())).setStartDate(batchOperationEntity.getStartDate()).setEndDate(batchOperationEntity.getEndDate()).setInstancesCount(batchOperationEntity.getInstancesCount()).setOperationsTotalCount(batchOperationEntity.getOperationsTotalCount()).setOperationsFinishedCount(batchOperationEntity.getOperationsFinishedCount()).setSortValues(SortValuesWrapper.createFrom(batchOperationEntity.getSortValues(), objectMapper));
    }

    public static List<BatchOperationDto> createFrom(List<BatchOperationEntity> batchOperationEntities, ObjectMapper objectMapper) {
        if (batchOperationEntities == null) {
            return new ArrayList<BatchOperationDto>();
        }
        return batchOperationEntities.stream().filter(item -> item != null).map(item -> BatchOperationDto.createFrom(item, objectMapper)).collect(Collectors.toList());
    }

    public String getName() {
        return this.name;
    }

    public BatchOperationDto setName(String name) {
        this.name = name;
        return this;
    }

    public OperationTypeDto getType() {
        return this.type;
    }

    public BatchOperationDto setType(OperationTypeDto type) {
        this.type = type;
        return this;
    }

    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public BatchOperationDto setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public BatchOperationDto setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    public Integer getInstancesCount() {
        return this.instancesCount;
    }

    public BatchOperationDto setInstancesCount(Integer instancesCount) {
        this.instancesCount = instancesCount;
        return this;
    }

    public Integer getOperationsTotalCount() {
        return this.operationsTotalCount;
    }

    public BatchOperationDto setOperationsTotalCount(Integer operationsTotalCount) {
        this.operationsTotalCount = operationsTotalCount;
        return this;
    }

    public Integer getOperationsFinishedCount() {
        return this.operationsFinishedCount;
    }

    public BatchOperationDto setOperationsFinishedCount(Integer operationsFinishedCount) {
        this.operationsFinishedCount = operationsFinishedCount;
        return this;
    }

    public Integer getFailedOperationsCount() {
        return this.failedOperationsCount;
    }

    public BatchOperationDto setFailedOperationsCount(Integer failedOperationsCount) {
        this.failedOperationsCount = failedOperationsCount;
        return this;
    }

    public Integer getCompletedOperationsCount() {
        return this.completedOperationsCount;
    }

    public BatchOperationDto setCompletedOperationsCount(Integer completedOperationsCount) {
        this.completedOperationsCount = completedOperationsCount;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public BatchOperationDto setId(String id) {
        this.id = id;
        return this;
    }

    public SortValuesWrapper[] getSortValues() {
        return this.sortValues;
    }

    public BatchOperationDto setSortValues(SortValuesWrapper[] sortValues) {
        this.sortValues = sortValues;
        return this;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.startDate != null ? this.startDate.hashCode() : 0);
        result = 31 * result + (this.endDate != null ? this.endDate.hashCode() : 0);
        result = 31 * result + (this.instancesCount != null ? this.instancesCount.hashCode() : 0);
        result = 31 * result + (this.operationsTotalCount != null ? this.operationsTotalCount.hashCode() : 0);
        result = 31 * result + (this.operationsFinishedCount != null ? this.operationsFinishedCount.hashCode() : 0);
        result = 31 * result + (this.completedOperationsCount != null ? this.completedOperationsCount.hashCode() : 0);
        result = 31 * result + (this.failedOperationsCount != null ? this.failedOperationsCount.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.sortValues);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchOperationDto that = (BatchOperationDto)o;
        if (!Objects.equals(this.id, that.id)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        if (!Objects.equals(this.startDate, that.startDate)) {
            return false;
        }
        if (!Objects.equals(this.endDate, that.endDate)) {
            return false;
        }
        if (!Objects.equals(this.instancesCount, that.instancesCount)) {
            return false;
        }
        if (!Objects.equals(this.operationsTotalCount, that.operationsTotalCount)) {
            return false;
        }
        if (!Objects.equals(this.operationsFinishedCount, that.operationsFinishedCount)) {
            return false;
        }
        if (!Objects.equals(this.failedOperationsCount, that.failedOperationsCount)) {
            return false;
        }
        if (!Objects.equals(this.completedOperationsCount, that.completedOperationsCount)) {
            return false;
        }
        return Arrays.equals(this.sortValues, that.sortValues);
    }
}

