/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.listview;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.exceptions.OperateRuntimeException;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.common.text.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortValuesWrapper
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortValuesWrapper.class);
    private static final Set<Class<?>> ALLOWED_SORTVALUE_TYPES = new HashSet();
    public String value;
    public Class valueType;

    public SortValuesWrapper() {
    }

    public SortValuesWrapper(String value, Class valueType) {
        this.value = value;
        this.valueType = valueType;
    }

    public static SortValuesWrapper[] createFrom(Object[] sortValues, ObjectMapper objectMapper) {
        if (sortValues == null) {
            return null;
        }
        try {
            LinkedList<SortValuesWrapper> sortValuesWrappers = new LinkedList<SortValuesWrapper>();
            for (Object sv : sortValues) {
                if (!ALLOWED_SORTVALUE_TYPES.contains(sv.getClass())) {
                    LOGGER.warn("Serializing a sort value type that is not in the deserialization allowed list: {}", sv.getClass());
                }
                sortValuesWrappers.add(new SortValuesWrapper(objectMapper.writeValueAsString(sv), sv.getClass()));
            }
            return sortValuesWrappers.toArray(new SortValuesWrapper[0]);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Unable to serialize sortValues. Error: " + e.getMessage(), (Throwable)e);
            throw new OperateRuntimeException((Throwable)e);
        }
    }

    public static Object[] convertSortValues(SortValuesWrapper[] sortValuesWrappers, ObjectMapper objectMapper) {
        if (sortValuesWrappers == null) {
            return null;
        }
        LinkedList<Object> sortValues = new LinkedList<Object>();
        for (SortValuesWrapper svw : sortValuesWrappers) {
            Class classType = svw.valueType;
            if (ALLOWED_SORTVALUE_TYPES.contains(classType)) {
                try {
                    sortValues.add(objectMapper.readValue(svw.value.getBytes(), classType));
                    continue;
                }
                catch (IOException e) {
                    LOGGER.error("Unable to deserialize sortValues. Error: {}", (Object)e.getMessage());
                    throw new OperateRuntimeException((Throwable)e);
                }
            }
            LOGGER.error("Unable to deserialize sortValues. Type {} is not allowed ", (Object)classType);
            throw new OperateRuntimeException("Invalid sortValues type: " + String.valueOf(classType));
        }
        return sortValues.toArray();
    }

    public Object getValue() {
        return this.value;
    }

    public SortValuesWrapper setValue(String value) {
        this.value = value;
        return this;
    }

    public Class getValueType() {
        return this.valueType;
    }

    public SortValuesWrapper setValueType(Class valueType) {
        this.valueType = valueType;
        return this;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.valueType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortValuesWrapper that = (SortValuesWrapper)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.valueType, that.valueType);
    }

    static {
        ALLOWED_SORTVALUE_TYPES.add(String.class);
        ALLOWED_SORTVALUE_TYPES.add(Text.class);
        ALLOWED_SORTVALUE_TYPES.add(Long.class);
        ALLOWED_SORTVALUE_TYPES.add(Integer.class);
        ALLOWED_SORTVALUE_TYPES.add(Short.class);
        ALLOWED_SORTVALUE_TYPES.add(Byte.class);
        ALLOWED_SORTVALUE_TYPES.add(Double.class);
        ALLOWED_SORTVALUE_TYPES.add(Float.class);
        ALLOWED_SORTVALUE_TYPES.add(Boolean.class);
        ALLOWED_SORTVALUE_TYPES.add(BigInteger.class);
    }
}

