/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto.incidents;

import java.util.Comparator;
import java.util.Objects;

public class IncidentByProcessStatisticsDto
implements Comparable<IncidentByProcessStatisticsDto> {
    public static final Comparator<IncidentByProcessStatisticsDto> COMPARATOR = new IncidentByProcessStatisticsDtoComparator();
    private String processId;
    private int version;
    private String name;
    private String bpmnProcessId;
    private String tenantId;
    private String errorMessage;
    private long instancesWithActiveIncidentsCount;
    private long activeInstancesCount;

    public IncidentByProcessStatisticsDto() {
    }

    public IncidentByProcessStatisticsDto(String processId, long instancesWithActiveIncidentsCount, long activeInstancesCount) {
        this.processId = processId;
        this.instancesWithActiveIncidentsCount = instancesWithActiveIncidentsCount;
        this.activeInstancesCount = activeInstancesCount;
    }

    public IncidentByProcessStatisticsDto(String processId, String errorMessage, long instancesWithActiveIncidentsCount) {
        this.processId = processId;
        this.errorMessage = errorMessage;
        this.instancesWithActiveIncidentsCount = instancesWithActiveIncidentsCount;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    public void setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessId = bpmnProcessId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public IncidentByProcessStatisticsDto setTenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getInstancesWithActiveIncidentsCount() {
        return this.instancesWithActiveIncidentsCount;
    }

    public void setInstancesWithActiveIncidentsCount(long instancesWithActiveIncidentsCount) {
        this.instancesWithActiveIncidentsCount = instancesWithActiveIncidentsCount;
    }

    public long getActiveInstancesCount() {
        return this.activeInstancesCount;
    }

    public void setActiveInstancesCount(long activeInstancesCount) {
        this.activeInstancesCount = activeInstancesCount;
    }

    public int hashCode() {
        return Objects.hash(this.processId, this.version, this.name, this.bpmnProcessId, this.tenantId, this.errorMessage, this.instancesWithActiveIncidentsCount, this.activeInstancesCount);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncidentByProcessStatisticsDto that = (IncidentByProcessStatisticsDto)o;
        return this.version == that.version && this.instancesWithActiveIncidentsCount == that.instancesWithActiveIncidentsCount && this.activeInstancesCount == that.activeInstancesCount && Objects.equals(this.processId, that.processId) && Objects.equals(this.name, that.name) && Objects.equals(this.bpmnProcessId, that.bpmnProcessId) && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    @Override
    public int compareTo(IncidentByProcessStatisticsDto o) {
        return COMPARATOR.compare(this, o);
    }

    public static class IncidentByProcessStatisticsDtoComparator
    implements Comparator<IncidentByProcessStatisticsDto> {
        @Override
        public int compare(IncidentByProcessStatisticsDto o1, IncidentByProcessStatisticsDto o2) {
            if (o1 == null) {
                if (o2 == null) {
                    return 0;
                }
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.equals(o2)) {
                return 0;
            }
            int result = Long.compare(o2.getInstancesWithActiveIncidentsCount(), o1.getInstancesWithActiveIncidentsCount());
            if (result == 0 && (result = Long.compare(o2.getActiveInstancesCount(), o1.getActiveInstancesCount())) == 0 && (result = this.emptyStringWhenNull(o1.getBpmnProcessId()).compareTo(this.emptyStringWhenNull(o2.getBpmnProcessId()))) == 0 && (result = this.emptyStringWhenNull(o1.getTenantId()).compareTo(this.emptyStringWhenNull(o2.getTenantId()))) == 0) {
                result = Integer.compare(o1.getVersion(), o2.getVersion());
            }
            return result;
        }

        private String emptyStringWhenNull(String aString) {
            return aString == null ? "" : aString;
        }
    }
}

