/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest.dto;

import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;

@Schema(description="Sorting")
public class SortingDto {
    public static final String SORT_ORDER_ASC_VALUE = "asc";
    public static final String SORT_ORDER_DESC_VALUE = "desc";
    public static final List<String> VALID_SORT_ORDER_VALUES = new ArrayList<String>();
    private String sortBy;
    private String sortOrder = "asc";

    @Schema(description="Data field to sort by", required=true)
    public String getSortBy() {
        return this.sortBy;
    }

    public SortingDto setSortBy(String sortBy) {
        this.sortBy = sortBy;
        return this;
    }

    @Schema(description="Sort order, default: asc", allowableValues={"asc,desc"}, required=false)
    public String getSortOrder() {
        return this.sortOrder;
    }

    public SortingDto setSortOrder(String sortOrder) {
        if (!VALID_SORT_ORDER_VALUES.contains(sortOrder)) {
            throw new InvalidRequestException("SortOrder parameter has invalid value: " + sortOrder);
        }
        this.sortOrder = sortOrder;
        return this;
    }

    public int hashCode() {
        int result = this.sortBy != null ? this.sortBy.hashCode() : 0;
        result = 31 * result + (this.sortOrder != null ? this.sortOrder.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortingDto that = (SortingDto)o;
        if (this.sortBy != null ? !this.sortBy.equals(that.sortBy) : that.sortBy != null) {
            return false;
        }
        return this.sortOrder != null ? this.sortOrder.equals(that.sortOrder) : that.sortOrder == null;
    }

    static {
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_ASC_VALUE);
        VALID_SORT_ORDER_VALUES.add(SORT_ORDER_DESC_VALUE);
    }
}

