/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.rest;

import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.entities.OperationType;
import io.camunda.operate.store.SequenceFlowStore;
import io.camunda.operate.util.rest.ValidLongId;
import io.camunda.operate.webapp.InternalAPIErrorController;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.reader.FlowNodeInstanceReader;
import io.camunda.operate.webapp.reader.FlowNodeStatisticsReader;
import io.camunda.operate.webapp.reader.IncidentReader;
import io.camunda.operate.webapp.reader.ListViewReader;
import io.camunda.operate.webapp.reader.ListenerReader;
import io.camunda.operate.webapp.reader.VariableReader;
import io.camunda.operate.webapp.rest.dto.DtoCreator;
import io.camunda.operate.webapp.rest.dto.FlowNodeStatisticsDto;
import io.camunda.operate.webapp.rest.dto.ListenerRequestDto;
import io.camunda.operate.webapp.rest.dto.ListenerResponseDto;
import io.camunda.operate.webapp.rest.dto.ProcessInstanceCoreStatisticsDto;
import io.camunda.operate.webapp.rest.dto.SequenceFlowDto;
import io.camunda.operate.webapp.rest.dto.VariableDto;
import io.camunda.operate.webapp.rest.dto.VariableRequestDto;
import io.camunda.operate.webapp.rest.dto.activity.FlowNodeStateDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentResponseDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewProcessInstanceDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewQueryDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewRequestDto;
import io.camunda.operate.webapp.rest.dto.listview.ListViewResponseDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataDto;
import io.camunda.operate.webapp.rest.dto.metadata.FlowNodeMetadataRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.CreateBatchOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.CreateOperationRequestDto;
import io.camunda.operate.webapp.rest.dto.operation.ModifyProcessInstanceRequestDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.rest.exception.NotAuthorizedException;
import io.camunda.operate.webapp.rest.validation.ModifyProcessInstanceRequestValidator;
import io.camunda.operate.webapp.rest.validation.ProcessInstanceRequestValidator;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import io.camunda.operate.webapp.writer.BatchOperationWriter;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import jakarta.validation.ConstraintViolationException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/process-instances"})
@Validated
public class ProcessInstanceRestService
extends InternalAPIErrorController {
    public static final String PROCESS_INSTANCE_URL = "/api/process-instances";
    protected final PermissionsService permissionsService;
    private final ProcessInstanceRequestValidator processInstanceRequestValidator;
    private final ModifyProcessInstanceRequestValidator modifyProcessInstanceRequestValidator;
    private final BatchOperationWriter batchOperationWriter;
    private final ProcessInstanceReader processInstanceReader;
    private final ListenerReader listenerReader;
    private final ListViewReader listViewReader;
    private final IncidentReader incidentReader;
    private final VariableReader variableReader;
    private final FlowNodeInstanceReader flowNodeInstanceReader;
    private final FlowNodeStatisticsReader flowNodeStatisticsReader;
    private final SequenceFlowStore sequenceFlowStore;

    public ProcessInstanceRestService(@Nullable PermissionsService permissionsService, ProcessInstanceRequestValidator processInstanceRequestValidator, ModifyProcessInstanceRequestValidator modifyProcessInstanceRequestValidator, BatchOperationWriter batchOperationWriter, ProcessInstanceReader processInstanceReader, ListenerReader listenerReader, ListViewReader listViewReader, IncidentReader incidentReader, VariableReader variableReader, FlowNodeInstanceReader flowNodeInstanceReader, FlowNodeStatisticsReader flowNodeStatisticsReader, SequenceFlowStore sequenceFlowStore) {
        this.permissionsService = permissionsService;
        this.processInstanceRequestValidator = processInstanceRequestValidator;
        this.modifyProcessInstanceRequestValidator = modifyProcessInstanceRequestValidator;
        this.batchOperationWriter = batchOperationWriter;
        this.processInstanceReader = processInstanceReader;
        this.listenerReader = listenerReader;
        this.listViewReader = listViewReader;
        this.incidentReader = incidentReader;
        this.variableReader = variableReader;
        this.flowNodeInstanceReader = flowNodeInstanceReader;
        this.flowNodeStatisticsReader = flowNodeStatisticsReader;
        this.sequenceFlowStore = sequenceFlowStore;
    }

    @Operation(summary="Query process instances by different parameters")
    @PostMapping
    @Timed(value="operate.query", extraTags={"name", "processInstances"}, description="How long does it take to retrieve the processinstances by query.")
    public ListViewResponseDto queryProcessInstances(@RequestBody ListViewRequestDto processInstanceRequest) {
        if (processInstanceRequest.getQuery() == null) {
            throw new InvalidRequestException("Query must be provided.");
        }
        if (processInstanceRequest.getQuery().getProcessVersion() != null && processInstanceRequest.getQuery().getBpmnProcessId() == null) {
            throw new InvalidRequestException("BpmnProcessId must be provided in request, when process version is not null.");
        }
        return this.listViewReader.queryProcessInstances(processInstanceRequest);
    }

    @Operation(summary="Perform single operation on an instance (async)")
    @PostMapping(value={"/{id}/operation"})
    @PreAuthorize(value="hasPermission('write')")
    public BatchOperationEntity operation(@PathVariable @ValidLongId String id, @RequestBody CreateOperationRequestDto operationRequest) {
        this.processInstanceRequestValidator.validateCreateOperationRequest(operationRequest, id);
        if (operationRequest.getOperationType() == OperationType.DELETE_PROCESS_INSTANCE) {
            this.checkIdentityPermission(Long.valueOf(id), IdentityPermission.DELETE_PROCESS_INSTANCE);
        } else {
            this.checkIdentityPermission(Long.valueOf(id), IdentityPermission.UPDATE_PROCESS_INSTANCE);
        }
        return this.batchOperationWriter.scheduleSingleOperation(Long.parseLong(id), operationRequest);
    }

    @Operation(summary="Perform modify process instance operation")
    @PostMapping(value={"/{id}/modify"})
    @PreAuthorize(value="hasPermission('write')")
    public BatchOperationEntity modify(@PathVariable @ValidLongId String id, @RequestBody ModifyProcessInstanceRequestDto modifyRequest) {
        modifyRequest.setProcessInstanceKey(id);
        this.modifyProcessInstanceRequestValidator.validate(modifyRequest);
        this.checkIdentityPermission(Long.valueOf(id), IdentityPermission.UPDATE_PROCESS_INSTANCE);
        return this.batchOperationWriter.scheduleModifyProcessInstance(modifyRequest);
    }

    @Operation(summary="Create batch operation based on filter")
    @PostMapping(value={"/batch-operation"})
    @PreAuthorize(value="hasPermission('write')")
    public BatchOperationEntity createBatchOperation(@RequestBody CreateBatchOperationRequestDto batchOperationRequest) {
        this.processInstanceRequestValidator.validateCreateBatchOperationRequest(batchOperationRequest);
        return this.batchOperationWriter.scheduleBatchOperation(batchOperationRequest);
    }

    @Operation(summary="Get process instance by id")
    @GetMapping(value={"/{id}"})
    public ListViewProcessInstanceDto queryProcessInstanceById(@PathVariable @ValidLongId String id) {
        this.checkIdentityReadPermission(Long.parseLong(id));
        return this.processInstanceReader.getProcessInstanceWithOperationsByKey(Long.valueOf(id));
    }

    @Operation(summary="Get incidents by process instance id")
    @GetMapping(value={"/{id}/incidents"})
    public IncidentResponseDto queryIncidentsByProcessInstanceId(@PathVariable @ValidLongId String id) {
        this.checkIdentityReadPermission(Long.parseLong(id));
        return this.incidentReader.getIncidentsByProcessInstanceId(id);
    }

    @Operation(summary="Get sequence flows by process instance id")
    @GetMapping(value={"/{id}/sequence-flows"})
    public List<SequenceFlowDto> querySequenceFlowsByProcessInstanceId(@PathVariable @ValidLongId String id) {
        this.checkIdentityReadPermission(Long.parseLong(id));
        List sequenceFlows = this.sequenceFlowStore.getSequenceFlowsByProcessInstanceKey(Long.valueOf(id));
        return DtoCreator.create(sequenceFlows, SequenceFlowDto.class);
    }

    @Operation(summary="Get variables by process instance id and scope id")
    @PostMapping(value={"/{processInstanceId}/variables"})
    public List<VariableDto> getVariables(@PathVariable @ValidLongId String processInstanceId, @RequestBody VariableRequestDto variableRequest) {
        this.checkIdentityReadPermission(Long.parseLong(processInstanceId));
        this.processInstanceRequestValidator.validateVariableRequest(variableRequest);
        return this.variableReader.getVariables(processInstanceId, variableRequest);
    }

    @Operation(summary="Get full variable by id")
    @GetMapping(value={"/{processInstanceId}/variables/{variableId}"})
    public VariableDto getVariable(@PathVariable @ValidLongId String processInstanceId, @PathVariable String variableId) {
        this.checkIdentityReadPermission(Long.parseLong(processInstanceId));
        return this.variableReader.getVariable(variableId);
    }

    @Operation(summary="Get listeners by process instance id")
    @PostMapping(value={"/{processInstanceId}/listeners"})
    public ListenerResponseDto getListeners(@PathVariable @ValidLongId String processInstanceId, @RequestBody ListenerRequestDto request) {
        this.checkIdentityReadPermission(Long.parseLong(processInstanceId));
        this.processInstanceRequestValidator.validateListenerRequest(request);
        return this.listenerReader.getListenerExecutions(processInstanceId, request);
    }

    @Operation(summary="Get flow node states by process instance id")
    @GetMapping(value={"/{processInstanceId}/flow-node-states"})
    public Map<String, FlowNodeStateDto> getFlowNodeStates(@PathVariable @ValidLongId String processInstanceId) {
        this.checkIdentityReadPermission(Long.parseLong(processInstanceId));
        return this.flowNodeInstanceReader.getFlowNodeStates(processInstanceId);
    }

    @Operation(summary="Get flow node statistic by process instance id")
    @GetMapping(value={"/{processInstanceId}/statistics"})
    public Collection<FlowNodeStatisticsDto> getStatistics(@PathVariable @ValidLongId String processInstanceId) {
        this.checkIdentityReadPermission(Long.parseLong(processInstanceId));
        return this.flowNodeInstanceReader.getFlowNodeStatisticsForProcessInstance(Long.parseLong(processInstanceId));
    }

    @Operation(summary="Get flow node metadata.")
    @PostMapping(value={"/{processInstanceId}/flow-node-metadata"})
    public FlowNodeMetadataDto getFlowNodeMetadata(@PathVariable @ValidLongId String processInstanceId, @RequestBody FlowNodeMetadataRequestDto request) {
        this.checkIdentityReadPermission(Long.parseLong(processInstanceId));
        this.processInstanceRequestValidator.validateFlowNodeMetadataRequest(request);
        return this.flowNodeInstanceReader.getFlowNodeMetadata(processInstanceId, request);
    }

    @Operation(summary="Get activity instance statistics")
    @PostMapping(path={"/statistics"})
    public Collection<FlowNodeStatisticsDto> getStatistics(@RequestBody ListViewQueryDto query) {
        this.processInstanceRequestValidator.validateFlowNodeStatisticsRequest(query);
        return this.flowNodeStatisticsReader.getFlowNodeStatistics(query);
    }

    @Operation(summary="Get process instance core statistics (aggregations)")
    @GetMapping(path={"/core-statistics"})
    @Timed(value="operate.query", extraTags={"name", "corestatistics"}, description="How long does it take to retrieve the core statistics.")
    public ProcessInstanceCoreStatisticsDto getCoreStatistics() {
        return this.processInstanceReader.getCoreStatistics();
    }

    @ExceptionHandler(value={ConstraintViolationException.class})
    public ResponseEntity<String> handleConstraintViolation(ConstraintViolationException exception) {
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)exception.getMessage());
    }

    private void checkIdentityReadPermission(Long processInstanceKey) {
        this.checkIdentityPermission(processInstanceKey, IdentityPermission.READ);
    }

    private void checkIdentityPermission(Long processInstanceKey, IdentityPermission permission) {
        if (this.permissionsService != null && !this.permissionsService.hasPermissionForProcess(this.processInstanceReader.getProcessInstanceByKey(processInstanceKey).getBpmnProcessId(), permission)) {
            throw new NotAuthorizedException(String.format("No %s permission for process instance %s", new Object[]{permission, processInstanceKey}));
        }
    }
}

