/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.writer;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.listview.ProcessInstanceForListViewEntity;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.OperationTemplate;
import io.camunda.operate.schema.templates.ProcessInstanceDependant;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.writer.ProcessInstanceWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchProcessInstanceWriter
implements ProcessInstanceWriter {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpensearchProcessInstanceWriter.class);
    @Autowired
    private ListViewTemplate processInstanceTemplate;
    @Autowired
    private List<ProcessInstanceDependant> processInstanceDependantTemplates;
    @Autowired
    private ProcessInstanceReader processInstanceReader;
    @Autowired
    private ProcessStore processStore;

    private static void validateDeletion(ProcessInstanceForListViewEntity processInstanceEntity) {
        if (!STATES_FOR_DELETION.contains(processInstanceEntity.getState())) {
            throw new IllegalArgumentException(String.format("Process instances needs to be in one of the states %s", STATES_FOR_DELETION));
        }
        if (processInstanceEntity.getEndDate() == null || processInstanceEntity.getEndDate().isAfter(OffsetDateTime.now())) {
            throw new IllegalArgumentException(String.format("Process instances needs to have an endDate before now: %s < %s", processInstanceEntity.getEndDate(), OffsetDateTime.now()));
        }
    }

    @Override
    public void deleteInstanceById(Long id) throws IOException {
        ProcessInstanceForListViewEntity processInstanceEntity = this.processInstanceReader.getProcessInstanceByKey(id);
        OpensearchProcessInstanceWriter.validateDeletion(processInstanceEntity);
        this.deleteProcessInstanceAndDependants(processInstanceEntity.getProcessInstanceKey().toString());
    }

    private void deleteProcessInstanceAndDependants(String processInstanceKey) throws IOException {
        List<ProcessInstanceDependant> processInstanceDependantsWithoutOperation = this.processInstanceDependantTemplates.stream().filter(t -> !(t instanceof OperationTemplate)).toList();
        for (ProcessInstanceDependant template : processInstanceDependantsWithoutOperation) {
            this.deleteDocument(template.getFullQualifiedName() + "*", "processInstanceKey", processInstanceKey);
        }
        this.deleteProcessInstanceFromTreePath(processInstanceKey);
        this.deleteDocument(this.processInstanceTemplate.getIndexPattern(), "processInstanceKey", processInstanceKey);
    }

    private void deleteProcessInstanceFromTreePath(String processInstanceKey) {
        this.processStore.deleteProcessInstanceFromTreePath(processInstanceKey);
    }

    private long deleteDocument(String indexName, String idField, String id) throws IOException {
        return this.processStore.deleteDocument(indexName, idField, id);
    }
}

