/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.JobEntity;
import io.camunda.operate.entities.ListenerType;
import io.camunda.operate.schema.templates.JobTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.webapp.opensearch.reader.OpensearchAbstractReader;
import io.camunda.operate.webapp.reader.ListenerReader;
import io.camunda.operate.webapp.rest.dto.ListenerDto;
import io.camunda.operate.webapp.rest.dto.ListenerRequestDto;
import io.camunda.operate.webapp.rest.dto.ListenerResponseDto;
import io.camunda.operate.webapp.rest.dto.listview.SortValuesWrapper;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchListenerReader
extends OpensearchAbstractReader
implements ListenerReader {
    private final JobTemplate jobTemplate;
    private final RichOpenSearchClient richOpenSearchClient;
    private final ObjectMapper objectMapper;

    public OpensearchListenerReader(JobTemplate jobTemplate, RichOpenSearchClient richOpenSearchClient, @Qualifier(value="operateObjectMapper") ObjectMapper objectMapper) {
        this.jobTemplate = jobTemplate;
        this.richOpenSearchClient = richOpenSearchClient;
        this.objectMapper = objectMapper;
    }

    @Override
    public ListenerResponseDto getListenerExecutions(String processInstanceId, ListenerRequestDto request) {
        Query query = QueryDSL.and((Query[])new Query[]{QueryDSL.term((String)"processInstanceKey", (String)processInstanceId), QueryDSL.term((String)"flowNodeId", (String)request.getFlowNodeId()), QueryDSL.or((Query[])new Query[]{QueryDSL.term((String)"jobKind", (String)ListenerType.EXECUTION_LISTENER.name()), QueryDSL.term((String)"jobKind", (String)ListenerType.TASK_LISTENER.name())})});
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((String)this.jobTemplate.getAlias()).query(query);
        this.applySorting(searchRequestBuilder, request);
        searchRequestBuilder.size(request.getPageSize());
        SearchResponse searchResult = this.richOpenSearchClient.doc().fixedSearch(searchRequestBuilder.build(), JobEntity.class);
        Long totalHitCount = searchResult.hits().total().value();
        List listeners = searchResult.hits().hits().stream().map(hit -> {
            JobEntity entity = (JobEntity)hit.source();
            SortValuesWrapper[] sortValues = SortValuesWrapper.createFrom(hit.sort().toArray(), this.objectMapper);
            return ListenerDto.fromJobEntity(entity).setSortValues(sortValues);
        }).collect(Collectors.toList());
        if (request.getSearchBefore() != null) {
            Collections.reverse(listeners);
        }
        return new ListenerResponseDto(listeners, totalHitCount);
    }

    private void applySorting(SearchRequest.Builder searchSourceBuilder, ListenerRequestDto request) {
        String missing;
        SortOrder sortOrder = SortOrder.Desc;
        if (request.getSorting() != null && request.getSorting().getSortOrder() != null) {
            sortOrder = "asc".equals(request.getSorting().getSortOrder()) ? SortOrder.Asc : SortOrder.Desc;
        }
        Object[] querySearchAfter = null;
        if (request.getSearchBefore() != null) {
            sortOrder = QueryDSL.reverseOrder((SortOrder)sortOrder);
            missing = "_last";
            querySearchAfter = request.getSearchBefore(this.objectMapper);
        } else {
            missing = "_first";
            if (request.getSearchAfter() != null) {
                querySearchAfter = request.getSearchAfter(this.objectMapper);
            }
        }
        if (querySearchAfter != null) {
            searchSourceBuilder.searchAfter(CollectionUtil.toSafeListOfStrings((Object[])querySearchAfter));
        }
        searchSourceBuilder.sort(QueryDSL.sortOptions((String)"endTime", (SortOrder)sortOrder, (String)missing), new SortOptions[0]).sort(QueryDSL.sortOptions((String)"key", (SortOrder)sortOrder), new SortOptions[0]);
    }
}

