/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.EventEntity;
import io.camunda.operate.schema.templates.EventTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.webapp.reader.EventReader;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.opensearch.client.opensearch.core.SearchResponse;
import org.opensearch.client.opensearch.core.search.Hit;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchEventReader
implements EventReader {
    private final EventTemplate eventTemplate;
    private final RichOpenSearchClient richOpenSearchClient;

    public OpensearchEventReader(EventTemplate eventTemplate, RichOpenSearchClient richOpenSearchClient) {
        this.eventTemplate = eventTemplate;
        this.richOpenSearchClient = richOpenSearchClient;
    }

    @Override
    public EventEntity getEventEntityByFlowNodeInstanceId(String flowNodeInstanceId) {
        SearchRequest.Builder request = RequestDSL.searchRequestBuilder((String)this.eventTemplate.getAlias()).query(QueryDSL.withTenantCheck((Query)QueryDSL.term((String)"flowNodeInstanceKey", (String)flowNodeInstanceId))).sort(QueryDSL.sortOptions((String)"id", (SortOrder)SortOrder.Asc), new SortOptions[0]);
        SearchResponse response = this.richOpenSearchClient.doc().search(request, EventEntity.class);
        if (response.hits().total().value() >= 1L) {
            return (EventEntity)((Hit)response.hits().hits().get(0)).source();
        }
        return null;
    }
}

