/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.opensearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.conditions.OpensearchCondition;
import io.camunda.operate.entities.BatchOperationEntity;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import io.camunda.operate.store.opensearch.client.sync.RichOpenSearchClient;
import io.camunda.operate.store.opensearch.dsl.QueryDSL;
import io.camunda.operate.store.opensearch.dsl.RequestDSL;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.webapp.reader.BatchOperationReader;
import io.camunda.operate.webapp.rest.dto.operation.BatchOperationRequestDto;
import io.camunda.operate.webapp.security.UserService;
import java.util.Arrays;
import java.util.List;
import org.opensearch.client.opensearch._types.SortOptions;
import org.opensearch.client.opensearch._types.SortOrder;
import org.opensearch.client.opensearch._types.query_dsl.Query;
import org.opensearch.client.opensearch.core.SearchRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={OpensearchCondition.class})
@Component
public class OpensearchBatchOperationReader
implements BatchOperationReader {
    @Autowired
    private BatchOperationTemplate batchOperationTemplate;
    @Autowired
    private UserService<?> userService;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;
    @Autowired
    private RichOpenSearchClient richOpenSearchClient;

    @Override
    public List<BatchOperationEntity> getBatchOperations(BatchOperationRequestDto batchOperationRequestDto) {
        SearchRequest.Builder searchRequestBuilder = this.createSearchRequest(batchOperationRequestDto);
        List<BatchOperationEntity> batchOperationEntities = this.richOpenSearchClient.doc().search(searchRequestBuilder, BatchOperationEntity.class).hits().hits().stream().map(hit -> {
            BatchOperationEntity entity = (BatchOperationEntity)hit.source();
            entity.setSortValues(hit.sort().toArray());
            return entity;
        }).toList();
        if (batchOperationRequestDto.getSearchBefore() != null) {
            return CollectionUtil.reversedView(batchOperationEntities);
        }
        return batchOperationEntities;
    }

    private SearchRequest.Builder createSearchRequest(BatchOperationRequestDto batchOperationRequestDto) {
        Object[] querySearchAfter;
        SortOptions sort2;
        SortOptions sort1;
        Object[] searchAfter = batchOperationRequestDto.getSearchAfter(this.objectMapper);
        Object[] searchBefore = batchOperationRequestDto.getSearchBefore(this.objectMapper);
        if (searchAfter != null || searchBefore == null) {
            sort1 = QueryDSL.sortOptions((String)"endDate", (SortOrder)SortOrder.Desc, (String)"_first");
            sort2 = QueryDSL.sortOptions((String)"startDate", (SortOrder)SortOrder.Desc);
            querySearchAfter = searchAfter;
        } else {
            sort1 = QueryDSL.sortOptions((String)"endDate", (SortOrder)SortOrder.Asc, (String)"_last");
            sort2 = QueryDSL.sortOptions((String)"startDate", (SortOrder)SortOrder.Asc);
            querySearchAfter = searchBefore;
        }
        SearchRequest.Builder searchRequestBuilder = RequestDSL.searchRequestBuilder((String)this.batchOperationTemplate.getAlias()).query(QueryDSL.constantScore((Query)QueryDSL.term((String)"username", (String)this.userService.getCurrentUser().getUsername()))).sort(sort1, new SortOptions[]{sort2}).size(batchOperationRequestDto.getPageSize());
        if (querySearchAfter != null) {
            searchRequestBuilder.searchAfter(Arrays.asList(ConversionUtils.toStringArray((Object[])querySearchAfter)));
        }
        return searchRequestBuilder;
    }
}

