/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.ProcessEntity;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.schema.templates.IncidentTemplate;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.store.ProcessStore;
import io.camunda.operate.store.elasticsearch.ElasticsearchIncidentStore;
import io.camunda.operate.util.ConversionUtils;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.elasticsearch.reader.AbstractReader;
import io.camunda.operate.webapp.reader.ProcessReader;
import io.camunda.operate.webapp.rest.dto.ProcessRequestDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentByProcessStatisticsDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentsByErrorMsgStatisticsDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentsByProcessGroupStatisticsDto;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.metrics.Cardinality;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class IncidentStatisticsReader
extends AbstractReader
implements io.camunda.operate.webapp.reader.IncidentStatisticsReader {
    private static final String ERROR_MESSAGE = "errorMessages";
    private static final String UNIQ_PROCESS_INSTANCES = "uniq_processInstances";
    private static final String GROUP_BY_ERROR_MESSAGE_HASH = "group_by_errorMessages";
    private static final String GROUP_BY_PROCESS_KEYS = "group_by_processDefinitionKeys";
    private static final Logger LOGGER = LoggerFactory.getLogger(IncidentStatisticsReader.class);
    @Autowired
    private ListViewTemplate processInstanceTemplate;
    @Autowired
    private IncidentTemplate incidentTemplate;
    @Autowired
    private ProcessReader processReader;
    @Autowired(required=false)
    private PermissionsService permissionsService;

    @Override
    public Set<IncidentsByProcessGroupStatisticsDto> getProcessAndIncidentsStatistics() {
        Map<Long, IncidentByProcessStatisticsDto> incidentsByProcessMap = this.updateActiveInstances(this.getIncidentsByProcess());
        return this.collectStatisticsForProcessGroups(incidentsByProcessMap);
    }

    @Override
    public Set<IncidentsByErrorMsgStatisticsDto> getIncidentStatisticsByError() {
        TreeSet<IncidentsByErrorMsgStatisticsDto> result = new TreeSet<IncidentsByErrorMsgStatisticsDto>(IncidentsByErrorMsgStatisticsDto.COMPARATOR);
        Map<Long, ProcessEntity> processes = this.processReader.getProcessesWithFields("key", "name", "bpmnProcessId", "tenantId", "version");
        TermsAggregationBuilder aggregation = (TermsAggregationBuilder)((TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)GROUP_BY_ERROR_MESSAGE_HASH).field("errorMessageHash")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)ERROR_MESSAGE).size(1).fetchSource("errorMessage", null))).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)GROUP_BY_PROCESS_KEYS).field("processDefinitionKey")).size(10000).subAggregation((AggregationBuilder)AggregationBuilders.cardinality((String)UNIQ_PROCESS_INSTANCES).field("processInstanceKey")));
        QueryBuilder query = ElasticsearchIncidentStore.ACTIVE_INCIDENT_QUERY;
        if (this.permissionsService != null) {
            query = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{ElasticsearchIncidentStore.ACTIVE_INCIDENT_QUERY, this.createQueryForProcessesByPermission(IdentityPermission.READ)});
        }
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.incidentTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query(query).aggregation((AggregationBuilder)aggregation).size(0));
        try {
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            Terms errorMessageAggregation = (Terms)searchResponse.getAggregations().get(GROUP_BY_ERROR_MESSAGE_HASH);
            for (Terms.Bucket bucket : errorMessageAggregation.getBuckets()) {
                result.add(this.getIncidentsByErrorMsgStatistic(processes, bucket));
            }
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining incidents by error message: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
        return result;
    }

    private Map<Long, IncidentByProcessStatisticsDto> getIncidentsByProcess() {
        HashMap<Long, IncidentByProcessStatisticsDto> results = new HashMap<Long, IncidentByProcessStatisticsDto>();
        SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.processInstanceTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query(INCIDENTS_QUERY).aggregation(COUNT_PROCESS_KEYS).size(0));
        try {
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            List buckets = ((Terms)searchResponse.getAggregations().get("processDefinitionKeys")).getBuckets();
            for (Terms.Bucket bucket : buckets) {
                Long processDefinitionKey = (Long)bucket.getKey();
                long incidents = bucket.getDocCount();
                results.put(processDefinitionKey, new IncidentByProcessStatisticsDto(processDefinitionKey.toString(), incidents, 0L));
            }
            return results;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining incidents by process: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private Map<Long, IncidentByProcessStatisticsDto> updateActiveInstances(Map<Long, IncidentByProcessStatisticsDto> statistics) {
        QueryBuilder runningInstanceQuery = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"state", (String)ProcessInstanceState.ACTIVE.toString()), QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance")});
        HashMap<Long, IncidentByProcessStatisticsDto> results = new HashMap<Long, IncidentByProcessStatisticsDto>(statistics);
        try {
            SearchRequest searchRequest = ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.processInstanceTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ONLY_RUNTIME).source(new SearchSourceBuilder().query(runningInstanceQuery).aggregation(COUNT_PROCESS_KEYS).size(0));
            SearchResponse searchResponse = this.tenantAwareClient.search(searchRequest);
            List buckets = ((Terms)searchResponse.getAggregations().get("processDefinitionKeys")).getBuckets();
            for (Terms.Bucket bucket : buckets) {
                Long processDefinitionKey = (Long)bucket.getKey();
                long runningCount = bucket.getDocCount();
                IncidentByProcessStatisticsDto statistic = (IncidentByProcessStatisticsDto)results.get(processDefinitionKey);
                if (statistic != null) {
                    statistic.setActiveInstancesCount(runningCount - statistic.getInstancesWithActiveIncidentsCount());
                } else {
                    statistic = new IncidentByProcessStatisticsDto(processDefinitionKey.toString(), 0L, runningCount);
                }
                results.put(processDefinitionKey, statistic);
            }
            return results;
        }
        catch (IOException e) {
            String message = String.format("Exception occurred, while obtaining active processes: %s", e.getMessage());
            LOGGER.error(message, (Throwable)e);
            throw new OperateRuntimeException(message, (Throwable)e);
        }
    }

    private Set<IncidentsByProcessGroupStatisticsDto> collectStatisticsForProcessGroups(Map<Long, IncidentByProcessStatisticsDto> incidentsByProcessMap) {
        TreeSet<IncidentsByProcessGroupStatisticsDto> result = new TreeSet<IncidentsByProcessGroupStatisticsDto>(IncidentsByProcessGroupStatisticsDto.COMPARATOR);
        Map<ProcessStore.ProcessKey, List<ProcessEntity>> processGroups = this.processReader.getProcessesGrouped(new ProcessRequestDto());
        for (List<ProcessEntity> processes : processGroups.values()) {
            IncidentsByProcessGroupStatisticsDto stat = new IncidentsByProcessGroupStatisticsDto();
            stat.setBpmnProcessId(processes.get(0).getBpmnProcessId());
            stat.setTenantId(processes.get(0).getTenantId());
            long activeInstancesCount = 0L;
            long instancesWithActiveIncidentsCount = 0L;
            long maxVersion = 0L;
            for (ProcessEntity processEntity : processes) {
                IncidentByProcessStatisticsDto statForProcess = incidentsByProcessMap.get(processEntity.getKey());
                if (statForProcess != null) {
                    activeInstancesCount += statForProcess.getActiveInstancesCount();
                    instancesWithActiveIncidentsCount += statForProcess.getInstancesWithActiveIncidentsCount();
                } else {
                    statForProcess = new IncidentByProcessStatisticsDto(ConversionUtils.toStringOrNull((Object)processEntity.getKey()), 0L, 0L);
                }
                statForProcess.setName(processEntity.getName());
                statForProcess.setBpmnProcessId(processEntity.getBpmnProcessId());
                statForProcess.setTenantId(processEntity.getTenantId());
                statForProcess.setVersion(processEntity.getVersion());
                stat.getProcesses().add(statForProcess);
                if ((long)processEntity.getVersion() <= maxVersion) continue;
                stat.setProcessName(processEntity.getName());
                maxVersion = processEntity.getVersion();
            }
            stat.setActiveInstancesCount(activeInstancesCount);
            stat.setInstancesWithActiveIncidentsCount(instancesWithActiveIncidentsCount);
            result.add(stat);
        }
        return result;
    }

    private QueryBuilder createQueryForProcessesByPermission(IdentityPermission permission) {
        PermissionsService.ResourcesAllowed allowed = this.permissionsService.getProcessesWithPermission(permission);
        if (allowed == null) {
            return null;
        }
        return allowed.isAll() ? QueryBuilders.matchAllQuery() : QueryBuilders.termsQuery((String)"bpmnProcessId", allowed.getIds());
    }

    private IncidentsByErrorMsgStatisticsDto getIncidentsByErrorMsgStatistic(Map<Long, ProcessEntity> processes, Terms.Bucket errorMessageBucket) {
        SearchHits searchHits = ((TopHits)errorMessageBucket.getAggregations().get(ERROR_MESSAGE)).getHits();
        SearchHit searchHit = searchHits.getHits()[0];
        String errorMessage = (String)searchHit.getSourceAsMap().get("errorMessage");
        IncidentsByErrorMsgStatisticsDto processStatistics = new IncidentsByErrorMsgStatisticsDto(errorMessage);
        Terms processDefinitionKeyAggregation = (Terms)errorMessageBucket.getAggregations().get(GROUP_BY_PROCESS_KEYS);
        for (Terms.Bucket processDefinitionKeyBucket : processDefinitionKeyAggregation.getBuckets()) {
            Long processDefinitionKey = (Long)processDefinitionKeyBucket.getKey();
            long incidentsCount = ((Cardinality)processDefinitionKeyBucket.getAggregations().get(UNIQ_PROCESS_INSTANCES)).getValue();
            if (processes.containsKey(processDefinitionKey)) {
                IncidentByProcessStatisticsDto statisticForProcess = new IncidentByProcessStatisticsDto(processDefinitionKey.toString(), errorMessage, incidentsCount);
                ProcessEntity process = processes.get(processDefinitionKey);
                statisticForProcess.setName(process.getName());
                statisticForProcess.setBpmnProcessId(process.getBpmnProcessId());
                statisticForProcess.setTenantId(process.getTenantId());
                statisticForProcess.setVersion(process.getVersion());
                processStatistics.getProcesses().add(statisticForProcess);
            }
            processStatistics.recordInstancesCount(incidentsCount);
        }
        return processStatistics;
    }
}

