/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import io.camunda.operate.cache.ProcessCache;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.ErrorType;
import io.camunda.operate.entities.IncidentEntity;
import io.camunda.operate.entities.OperationEntity;
import io.camunda.operate.store.FlowNodeStore;
import io.camunda.operate.store.IncidentStore;
import io.camunda.operate.util.TreePath;
import io.camunda.operate.webapp.data.IncidentDataHolder;
import io.camunda.operate.webapp.elasticsearch.reader.AbstractReader;
import io.camunda.operate.webapp.elasticsearch.reader.ProcessInstanceReader;
import io.camunda.operate.webapp.reader.OperationReader;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentErrorTypeDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentFlowNodeDto;
import io.camunda.operate.webapp.rest.dto.incidents.IncidentResponseDto;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class IncidentReader
extends AbstractReader
implements io.camunda.operate.webapp.reader.IncidentReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(IncidentReader.class);
    @Autowired
    private OperationReader operationReader;
    @Autowired
    private ProcessInstanceReader processInstanceReader;
    @Autowired
    private ProcessCache processCache;
    @Autowired
    private IncidentStore incidentStore;
    @Autowired
    private FlowNodeStore flowNodeStore;

    @Override
    public List<IncidentEntity> getAllIncidentsByProcessInstanceKey(Long processInstanceKey) {
        return this.incidentStore.getIncidentsByProcessInstanceKey(processInstanceKey);
    }

    @Override
    public Map<Long, List<Long>> getIncidentKeysPerProcessInstance(List<Long> processInstanceKeys) {
        return this.incidentStore.getIncidentKeysPerProcessInstance(processInstanceKeys);
    }

    @Override
    public IncidentEntity getIncidentById(Long incidentKey) {
        return this.incidentStore.getIncidentById(incidentKey);
    }

    @Override
    public IncidentResponseDto getIncidentsByProcessInstanceId(String processInstanceId) {
        String treePath = this.processInstanceReader.getProcessInstanceTreePath(processInstanceId);
        ArrayList errorTypes = new ArrayList();
        List incidents = this.incidentStore.getIncidentsWithErrorTypesFor(treePath, errorTypes);
        IncidentResponseDto incidentResponse = new IncidentResponseDto();
        incidentResponse.setErrorTypes(errorTypes.stream().map(m -> {
            Map.Entry entry = m.entrySet().iterator().next();
            return IncidentErrorTypeDto.createFrom((ErrorType)entry.getKey()).setCount(((Long)entry.getValue()).intValue());
        }).collect(Collectors.toList()));
        HashMap<Long, String> processNames = new HashMap<Long, String>();
        incidents.stream().filter(inc -> processNames.get(inc.getProcessDefinitionKey()) == null).forEach(inc -> processNames.put(inc.getProcessDefinitionKey(), this.processCache.getProcessNameOrBpmnProcessId(inc.getProcessDefinitionKey(), "Unknown process")));
        Map<Long, List<OperationEntity>> operations = this.operationReader.getOperationsPerIncidentKey(processInstanceId);
        Map<String, IncidentDataHolder> incData = this.collectFlowNodeDataForPropagatedIncidents(incidents, processInstanceId, treePath);
        incidentResponse.setFlowNodes(incData.values().stream().collect(Collectors.groupingBy(IncidentDataHolder::getFinalFlowNodeId, Collectors.counting())).entrySet().stream().map(entry -> new IncidentFlowNodeDto((String)entry.getKey(), ((Long)entry.getValue()).intValue())).collect(Collectors.toList()));
        List<IncidentDto> incidentsDtos = IncidentDto.sortDefault(IncidentDto.createFrom(incidents, operations, processNames, incData));
        incidentResponse.setIncidents(incidentsDtos);
        incidentResponse.setCount(incidents.size());
        return incidentResponse;
    }

    @Override
    public Map<String, IncidentDataHolder> collectFlowNodeDataForPropagatedIncidents(List<IncidentEntity> incidents, String processInstanceId, String currentTreePath) {
        HashSet<String> flowNodeInstanceIdsSet = new HashSet<String>();
        HashMap<String, IncidentDataHolder> incDatas = new HashMap<String, IncidentDataHolder>();
        for (IncidentEntity inc : incidents) {
            IncidentDataHolder incData = new IncidentDataHolder().setIncidentId(inc.getId());
            if (!String.valueOf(inc.getProcessInstanceKey()).equals(processInstanceId)) {
                String callActivityInstanceId = TreePath.extractFlowNodeInstanceId((String)inc.getTreePath(), (String)currentTreePath);
                incData.setFinalFlowNodeInstanceId(callActivityInstanceId);
                flowNodeInstanceIdsSet.add(callActivityInstanceId);
            } else {
                incData.setFinalFlowNodeInstanceId(String.valueOf(inc.getFlowNodeInstanceKey()));
                incData.setFinalFlowNodeId(inc.getFlowNodeId());
            }
            incDatas.put(inc.getId(), incData);
        }
        if (flowNodeInstanceIdsSet.size() > 0) {
            Map flowNodeIdsMap = this.flowNodeStore.getFlowNodeIdsForFlowNodeInstances(flowNodeInstanceIdsSet);
            incDatas.values().stream().filter(iData -> iData.getFinalFlowNodeId() == null).forEach(iData -> iData.setFinalFlowNodeId((String)flowNodeIdsMap.get(iData.getFinalFlowNodeInstanceId())));
        }
        return incDatas;
    }
}

