/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch.reader;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.entities.OperateEntity;
import io.camunda.operate.tenant.TenantAwareElasticsearchClient;
import io.camunda.operate.util.ElasticsearchUtil;
import java.io.IOException;
import java.util.List;
import java.util.function.Consumer;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public abstract class AbstractReader {
    @Autowired
    protected RestHighLevelClient esClient;
    @Autowired
    protected TenantAwareElasticsearchClient tenantAwareClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    protected ObjectMapper objectMapper;

    protected <T extends OperateEntity> List<T> scroll(SearchRequest searchRequest, Class<T> clazz) throws IOException {
        return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, (Class)clazz, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient));
    }

    protected <T extends OperateEntity> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, Consumer<Aggregations> aggsProcessor) throws IOException {
        return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, (Class)clazz, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient, null, (Consumer)aggsProcessor));
    }

    protected <T extends OperateEntity> List<T> scroll(SearchRequest searchRequest, Class<T> clazz, Consumer<SearchHits> searchHitsProcessor, Consumer<Aggregations> aggsProcessor) throws IOException {
        return (List)this.tenantAwareClient.search(searchRequest, () -> ElasticsearchUtil.scroll((SearchRequest)searchRequest, (Class)clazz, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient, (Consumer)searchHitsProcessor, (Consumer)aggsProcessor));
    }
}

