/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.webapp.elasticsearch;

import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.entities.FlowNodeState;
import io.camunda.operate.entities.FlowNodeType;
import io.camunda.operate.entities.listview.ProcessInstanceState;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.TemplateDescriptor;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.util.ElasticsearchUtil;
import io.camunda.operate.webapp.rest.dto.listview.ListViewQueryDto;
import io.camunda.operate.webapp.rest.dto.listview.VariablesQueryDto;
import io.camunda.operate.webapp.rest.exception.InvalidRequestException;
import io.camunda.operate.webapp.security.identity.IdentityPermission;
import io.camunda.operate.webapp.security.identity.PermissionsService;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.join.query.JoinQueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class QueryHelper {
    public static final String WILD_CARD = "*";
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private DateTimeFormatter dateTimeFormatter;
    @Autowired(required=false)
    private PermissionsService permissionsService;
    @Autowired
    private ListViewTemplate listViewTemplate;

    public SearchRequest createSearchRequest(ListViewQueryDto processInstanceRequest) {
        if (processInstanceRequest.isFinished()) {
            return ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.listViewTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ALL);
        }
        return ElasticsearchUtil.createSearchRequest((TemplateDescriptor)this.listViewTemplate, (ElasticsearchUtil.QueryType)ElasticsearchUtil.QueryType.ONLY_RUNTIME);
    }

    public QueryBuilder createRequestQuery(ListViewQueryDto request) {
        QueryBuilder query = this.createQueryFragment(request);
        TermQueryBuilder isProcessInstanceQuery = QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance");
        QueryBuilder queryBuilder = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{isProcessInstanceQuery, query});
        return QueryBuilders.constantScoreQuery((QueryBuilder)queryBuilder);
    }

    public ConstantScoreQueryBuilder createProcessInstancesQuery(ListViewQueryDto query) {
        TermQueryBuilder isProcessInstanceQuery = QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance");
        QueryBuilder queryBuilder = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{isProcessInstanceQuery, this.createQueryFragment(query)});
        return QueryBuilders.constantScoreQuery((QueryBuilder)queryBuilder);
    }

    public QueryBuilder createQueryFragment(ListViewQueryDto query) {
        return ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{this.createRunningFinishedQuery(query), this.createRetriesLeftQuery(query), this.createActivityIdQuery(query), this.createIdsQuery(query), this.createErrorMessageQuery(query), this.createStartDateQuery(query), this.createEndDateQuery(query), this.createProcessDefinitionKeysQuery(query), this.createBpmnProcessIdQuery(query), this.createExcludeIdsQuery(query), this.createVariablesQuery(query), this.createVariablesInQuery(query), this.createBatchOperationIdQuery(query), this.createParentInstanceIdQuery(query), this.createTenantIdQuery(query), this.createReadPermissionQuery()});
    }

    private QueryBuilder createReadPermissionQuery() {
        if (this.permissionsService == null) {
            return null;
        }
        PermissionsService.ResourcesAllowed allowed = this.permissionsService.getProcessesWithPermission(IdentityPermission.READ);
        if (allowed == null) {
            return null;
        }
        return allowed.isAll() ? QueryBuilders.matchAllQuery() : QueryBuilders.termsQuery((String)"bpmnProcessId", allowed.getIds());
    }

    private QueryBuilder createBatchOperationIdQuery(ListViewQueryDto query) {
        if (query.getBatchOperationId() != null) {
            return QueryBuilders.termQuery((String)"batchOperationIds", (String)query.getBatchOperationId());
        }
        return null;
    }

    private QueryBuilder createParentInstanceIdQuery(ListViewQueryDto query) {
        if (query.getParentInstanceId() != null) {
            return QueryBuilders.termQuery((String)"parentProcessInstanceKey", (Object)query.getParentInstanceId());
        }
        return null;
    }

    private QueryBuilder createTenantIdQuery(ListViewQueryDto query) {
        if (query.getTenantId() != null) {
            return QueryBuilders.termQuery((String)"tenantId", (String)query.getTenantId());
        }
        return null;
    }

    private QueryBuilder createProcessDefinitionKeysQuery(ListViewQueryDto query) {
        if (CollectionUtil.isNotEmpty(query.getProcessIds())) {
            return QueryBuilders.termsQuery((String)"processDefinitionKey", query.getProcessIds());
        }
        return null;
    }

    private QueryBuilder createBpmnProcessIdQuery(ListViewQueryDto query) {
        if (!StringUtils.isEmpty((Object)query.getBpmnProcessId())) {
            TermQueryBuilder bpmnProcessIdQ = QueryBuilders.termQuery((String)"bpmnProcessId", (String)query.getBpmnProcessId());
            TermQueryBuilder versionQ = null;
            if (query.getProcessVersion() != null) {
                versionQ = QueryBuilders.termQuery((String)"processVersion", (Object)query.getProcessVersion());
            }
            return ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{bpmnProcessIdQ, versionQ});
        }
        return null;
    }

    private QueryBuilder createVariablesQuery(ListViewQueryDto query) {
        VariablesQueryDto variablesQuery = query.getVariable();
        if (variablesQuery != null && StringUtils.hasLength((String)variablesQuery.getValue())) {
            if (variablesQuery.getName() == null) {
                throw new InvalidRequestException("Variables query must provide not-null variable name.");
            }
            return JoinQueryBuilders.hasChildQuery((String)"variable", (QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"varName", (String)variablesQuery.getName()), QueryBuilders.termQuery((String)"varValue", (String)variablesQuery.getValue())}), (ScoreMode)ScoreMode.None);
        }
        return null;
    }

    private QueryBuilder createVariablesInQuery(ListViewQueryDto query) {
        VariablesQueryDto variablesQuery = query.getVariable();
        if (variablesQuery != null && !ArrayUtils.isEmpty((Object[])variablesQuery.getValues())) {
            if (variablesQuery.getName() == null) {
                throw new InvalidRequestException("Variables query must provide not-null variable name.");
            }
            return JoinQueryBuilders.hasChildQuery((String)"variable", (QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{QueryBuilders.termQuery((String)"varName", (String)variablesQuery.getName()), QueryBuilders.termsQuery((String)"varValue", (String[])variablesQuery.getValues())}), (ScoreMode)ScoreMode.None);
        }
        return null;
    }

    private QueryBuilder createExcludeIdsQuery(ListViewQueryDto query) {
        if (CollectionUtil.isNotEmpty(query.getExcludeIds())) {
            return QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"id", query.getExcludeIds()));
        }
        return null;
    }

    private QueryBuilder createEndDateQuery(ListViewQueryDto query) {
        if (query.getEndDateAfter() != null || query.getEndDateBefore() != null) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"endDate");
            if (query.getEndDateAfter() != null) {
                rangeQueryBuilder.gte((Object)this.dateTimeFormatter.format(query.getEndDateAfter()));
            }
            if (query.getEndDateBefore() != null) {
                rangeQueryBuilder.lt((Object)this.dateTimeFormatter.format(query.getEndDateBefore()));
            }
            rangeQueryBuilder.format(this.operateProperties.getElasticsearch().getElsDateFormat());
            return rangeQueryBuilder;
        }
        return null;
    }

    private QueryBuilder createStartDateQuery(ListViewQueryDto query) {
        if (query.getStartDateAfter() != null || query.getStartDateBefore() != null) {
            RangeQueryBuilder rangeQueryBuilder = QueryBuilders.rangeQuery((String)"startDate");
            if (query.getStartDateAfter() != null) {
                rangeQueryBuilder.gte((Object)this.dateTimeFormatter.format(query.getStartDateAfter()));
            }
            if (query.getStartDateBefore() != null) {
                rangeQueryBuilder.lt((Object)this.dateTimeFormatter.format(query.getStartDateBefore()));
            }
            rangeQueryBuilder.format(this.operateProperties.getElasticsearch().getElsDateFormat());
            return rangeQueryBuilder;
        }
        return null;
    }

    private QueryBuilder createErrorMessageAsAndMatchQuery(String errorMessage) {
        return JoinQueryBuilders.hasChildQuery((String)"activity", (QueryBuilder)QueryBuilders.matchQuery((String)"errorMessage", (Object)errorMessage).operator(Operator.AND), (ScoreMode)ScoreMode.None);
    }

    private QueryBuilder createErrorMessageAsWildcardQuery(String errorMessage) {
        return JoinQueryBuilders.hasChildQuery((String)"activity", (QueryBuilder)QueryBuilders.wildcardQuery((String)"errorMessage", (String)errorMessage), (ScoreMode)ScoreMode.None);
    }

    private QueryBuilder createErrorMessageQuery(ListViewQueryDto query) {
        String errorMessage = query.getErrorMessage();
        if (!StringUtils.isEmpty((Object)errorMessage)) {
            if (errorMessage.contains(WILD_CARD)) {
                return this.createErrorMessageAsWildcardQuery(errorMessage.toLowerCase());
            }
            return this.createErrorMessageAsAndMatchQuery(errorMessage);
        }
        return null;
    }

    private QueryBuilder createIdsQuery(ListViewQueryDto query) {
        if (CollectionUtil.isNotEmpty(query.getIds())) {
            return QueryBuilders.termsQuery((String)"id", query.getIds());
        }
        return null;
    }

    private QueryBuilder createRunningFinishedQuery(ListViewQueryDto query) {
        QueryBuilder processInstanceQuery;
        boolean active = query.isActive();
        boolean incidents = query.isIncidents();
        boolean running = query.isRunning();
        boolean completed = query.isCompleted();
        boolean canceled = query.isCanceled();
        boolean finished = query.isFinished();
        if (!running && !finished) {
            return ElasticsearchUtil.createMatchNoneQuery();
        }
        if (running && finished && active && incidents && completed && canceled) {
            return null;
        }
        BoolQueryBuilder runningQuery = null;
        if (running && (active || incidents)) {
            runningQuery = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)"endDate"));
            QueryBuilder activeQuery = this.createActiveQuery(query);
            QueryBuilder incidentsQuery = this.createIncidentsQuery(query);
            if (query.getActivityId() != null || !query.isActive() || !query.isIncidents()) {
                runningQuery = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{runningQuery, ElasticsearchUtil.joinWithOr((QueryBuilder[])new QueryBuilder[]{activeQuery, incidentsQuery})});
            }
        }
        ExistsQueryBuilder finishedQuery = null;
        if (finished && (completed || canceled)) {
            finishedQuery = QueryBuilders.existsQuery((String)"endDate");
            QueryBuilder completedQuery = this.createCompletedQuery(query);
            QueryBuilder canceledQuery = this.createCanceledQuery(query);
            if (query.getActivityId() != null || !query.isCompleted() || !query.isCanceled()) {
                finishedQuery = ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{finishedQuery, ElasticsearchUtil.joinWithOr((QueryBuilder[])new QueryBuilder[]{completedQuery, canceledQuery})});
            }
        }
        if ((processInstanceQuery = ElasticsearchUtil.joinWithOr((QueryBuilder[])new QueryBuilder[]{runningQuery, finishedQuery})) == null) {
            return ElasticsearchUtil.createMatchNoneQuery();
        }
        return processInstanceQuery;
    }

    private QueryBuilder createRetriesLeftQuery(ListViewQueryDto query) {
        if (query.isRetriesLeft()) {
            TermQueryBuilder retriesLeftQuery = QueryBuilders.termQuery((String)"jobFailedWithRetriesLeft", (boolean)true);
            return JoinQueryBuilders.hasChildQuery((String)"activity", (QueryBuilder)retriesLeftQuery, (ScoreMode)ScoreMode.None);
        }
        return null;
    }

    private QueryBuilder createActivityIdQuery(ListViewQueryDto query) {
        if (StringUtils.isEmpty((Object)query.getActivityId())) {
            return null;
        }
        QueryBuilder activeActivityIdQuery = null;
        if (query.isActive()) {
            activeActivityIdQuery = this.createActivityIdQuery(query.getActivityId(), FlowNodeState.ACTIVE);
        }
        QueryBuilder incidentActivityIdQuery = null;
        if (query.isIncidents()) {
            incidentActivityIdQuery = this.createActivityIdIncidentQuery(query.getActivityId());
        }
        QueryBuilder completedActivityIdQuery = null;
        if (query.isCompleted()) {
            completedActivityIdQuery = this.createActivityIdQuery(query.getActivityId(), FlowNodeState.COMPLETED);
        }
        QueryBuilder canceledActivityIdQuery = null;
        if (query.isCanceled()) {
            canceledActivityIdQuery = this.createActivityIdQuery(query.getActivityId(), FlowNodeState.TERMINATED);
        }
        return ElasticsearchUtil.joinWithOr((QueryBuilder[])new QueryBuilder[]{activeActivityIdQuery, incidentActivityIdQuery, completedActivityIdQuery, canceledActivityIdQuery});
    }

    private QueryBuilder createCanceledQuery(ListViewQueryDto query) {
        if (query.isCanceled()) {
            return QueryBuilders.termQuery((String)"state", (String)ProcessInstanceState.CANCELED.toString());
        }
        return null;
    }

    private QueryBuilder createCompletedQuery(ListViewQueryDto query) {
        if (query.isCompleted()) {
            return QueryBuilders.termQuery((String)"state", (String)ProcessInstanceState.COMPLETED.toString());
        }
        return null;
    }

    private QueryBuilder createIncidentsQuery(ListViewQueryDto query) {
        if (query.isIncidents()) {
            return QueryBuilders.termQuery((String)"incident", (boolean)true);
        }
        return null;
    }

    private QueryBuilder createActiveQuery(ListViewQueryDto query) {
        if (query.isActive()) {
            return QueryBuilders.termQuery((String)"incident", (boolean)false);
        }
        return null;
    }

    private QueryBuilder createActivityIdQuery(String activityId, FlowNodeState state) {
        TermQueryBuilder activitiesQuery = QueryBuilders.termQuery((String)"activityState", (String)state.name());
        TermQueryBuilder activityIdQuery = QueryBuilders.termQuery((String)"activityId", (String)activityId);
        TermQueryBuilder activityIsEndNodeQuery = null;
        if (state.equals((Object)FlowNodeState.COMPLETED)) {
            activityIsEndNodeQuery = QueryBuilders.termQuery((String)"activityType", (String)FlowNodeType.END_EVENT.name());
        }
        return JoinQueryBuilders.hasChildQuery((String)"activity", (QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{activitiesQuery, activityIdQuery, activityIsEndNodeQuery}), (ScoreMode)ScoreMode.None);
    }

    private QueryBuilder createActivityIdIncidentQuery(String activityId) {
        TermQueryBuilder activitiesQuery = QueryBuilders.termQuery((String)"activityState", (String)FlowNodeState.ACTIVE.name());
        TermQueryBuilder activityIdQuery = QueryBuilders.termQuery((String)"activityId", (String)activityId);
        ExistsQueryBuilder incidentExists = QueryBuilders.existsQuery((String)"errorMessage");
        return JoinQueryBuilders.hasChildQuery((String)"activity", (QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{activitiesQuery, activityIdQuery, incidentExists}), (ScoreMode)ScoreMode.None);
    }
}

