/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.archiver;

import io.camunda.operate.Metrics;
import io.camunda.operate.archiver.AbstractArchiverJob;
import io.camunda.operate.archiver.ArchiveBatch;
import io.camunda.operate.archiver.Archiver;
import io.camunda.operate.archiver.ArchiverRepository;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.schema.templates.ProcessInstanceDependant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ProcessInstancesArchiverJob
extends AbstractArchiverJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessInstancesArchiverJob.class);
    private final List<Integer> partitionIds;
    private final Archiver archiver;
    @Autowired
    private ListViewTemplate processInstanceTemplate;
    @Autowired
    private List<ProcessInstanceDependant> processInstanceDependantTemplates;
    @Autowired
    private Metrics metrics;
    @Autowired
    private ArchiverRepository archiverRepository;

    public ProcessInstancesArchiverJob(Archiver archiver, List<Integer> partitionIds) {
        this.partitionIds = partitionIds;
        this.archiver = archiver;
    }

    @Override
    public CompletableFuture<Integer> archiveBatch(ArchiveBatch archiveBatch) {
        CompletableFuture<Integer> archiveBatchFuture;
        if (archiveBatch != null) {
            LOGGER.debug("Following process instances are found for archiving: {}", (Object)archiveBatch);
            archiveBatchFuture = new CompletableFuture();
            String finishDate = archiveBatch.getFinishDate();
            List<Object> processInstanceKeys = archiveBatch.getIds();
            ((CompletableFuture)((CompletableFuture)this.moveDependableDocuments(finishDate, processInstanceKeys).thenCompose(v -> this.moveProcessInstanceDocuments(finishDate, processInstanceKeys))).thenAccept(i -> {
                this.metrics.recordCounts("archived.process.instances", (long)i.intValue(), new String[0]);
                archiveBatchFuture.complete((Integer)i);
            })).exceptionally(t -> {
                archiveBatchFuture.completeExceptionally((Throwable)t);
                return null;
            });
        } else {
            LOGGER.debug("Nothing to archive");
            archiveBatchFuture = CompletableFuture.completedFuture(0);
        }
        return archiveBatchFuture;
    }

    @Override
    public CompletableFuture<ArchiveBatch> getNextBatch() {
        return this.archiverRepository.getProcessInstancesNextBatch(this.partitionIds);
    }

    private CompletableFuture<Void> moveDependableDocuments(String finishDate, List<Object> processInstanceKeys) {
        ArrayList<CompletableFuture<Void>> dependableFutures = new ArrayList<CompletableFuture<Void>>();
        for (ProcessInstanceDependant template : this.processInstanceDependantTemplates) {
            CompletableFuture<Void> moveDocumentsFuture = this.archiver.moveDocuments(template.getFullQualifiedName(), "processInstanceKey", finishDate, processInstanceKeys);
            dependableFutures.add(moveDocumentsFuture);
        }
        return CompletableFuture.allOf(dependableFutures.toArray(new CompletableFuture[dependableFutures.size()]));
    }

    private CompletableFuture<Integer> moveProcessInstanceDocuments(String finishDate, List<Object> processInstanceKeys) {
        CompletableFuture<Integer> future = new CompletableFuture<Integer>();
        ((CompletableFuture)this.archiver.moveDocuments(this.processInstanceTemplate.getFullQualifiedName(), "processInstanceKey", finishDate, processInstanceKeys).thenAccept(ignore -> future.complete(processInstanceKeys.size()))).exceptionally(t -> {
            future.completeExceptionally((Throwable)t);
            return null;
        });
        return future;
    }
}

