/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.archiver;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.camunda.operate.Metrics;
import io.camunda.operate.archiver.ArchiveBatch;
import io.camunda.operate.archiver.ArchiverRepository;
import io.camunda.operate.conditions.ElasticsearchCondition;
import io.camunda.operate.exceptions.OperateRuntimeException;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import io.camunda.operate.schema.templates.ListViewTemplate;
import io.camunda.operate.util.Either;
import io.camunda.operate.util.ElasticsearchUtil;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.client.indices.GetIndexRequest;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.query.ConstantScoreQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.index.query.TermsQueryBuilder;
import org.elasticsearch.index.reindex.ReindexRequest;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.PipelineAggregatorBuilders;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.TopHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Conditional(value={ElasticsearchCondition.class})
@Component
public class ElasticsearchArchiverRepository
implements ArchiverRepository {
    public static final int INTERNAL_SCROLL_KEEP_ALIVE_MS = 30000;
    private static final Logger LOGGER = LoggerFactory.getLogger(ElasticsearchArchiverRepository.class);
    @Autowired
    @Qualifier(value="archiverThreadPoolExecutor")
    protected ThreadPoolTaskScheduler archiverExecutor;
    @Autowired
    private BatchOperationTemplate batchOperationTemplate;
    @Autowired
    private ListViewTemplate processInstanceTemplate;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private Metrics metrics;
    @Autowired
    private RestHighLevelClient esClient;
    @Autowired
    @Qualifier(value="operateObjectMapper")
    private ObjectMapper objectMapper;

    private ArchiveBatch createArchiveBatch(SearchResponse searchResponse, String datesAggName, String instancesAggName) {
        List buckets = ((Histogram)searchResponse.getAggregations().get(datesAggName)).getBuckets();
        if (buckets.size() > 0) {
            Histogram.Bucket bucket = (Histogram.Bucket)buckets.get(0);
            String finishDate = bucket.getKeyAsString();
            SearchHits hits = ((TopHits)bucket.getAggregations().get(instancesAggName)).getHits();
            ArrayList ids = Arrays.stream(hits.getHits()).collect(ArrayList::new, (list, hit) -> list.add(hit.getId()), (list1, list2) -> list1.addAll(list2));
            return new ArchiveBatch(finishDate, ids);
        }
        return null;
    }

    private CompletableFuture<SearchResponse> sendSearchRequest(SearchRequest searchRequest) {
        return ElasticsearchUtil.searchAsync((SearchRequest)searchRequest, (Executor)this.archiverExecutor, (RestHighLevelClient)this.esClient);
    }

    private CompletableFuture<ArchiveBatch> searchAsync(SearchRequest searchRequest, Function<Throwable, String> errorMessage) {
        CompletableFuture<ArchiveBatch> batchFuture = new CompletableFuture<ArchiveBatch>();
        Timer.Sample startTimer = Timer.start();
        this.sendSearchRequest(searchRequest).whenComplete((response, e) -> {
            Timer timer = this.getArchiverQueryTimer();
            startTimer.stop(timer);
            Either<Throwable, ArchiveBatch> result = this.handleSearchResponse((SearchResponse)response, (Throwable)e, errorMessage);
            result.ifRightOrLeft(batchFuture::complete, batchFuture::completeExceptionally);
        });
        return batchFuture;
    }

    @Override
    public CompletableFuture<ArchiveBatch> getBatchOperationNextBatch() {
        AggregationBuilder aggregation = this.createFinishedBatchOperationsAggregation("datesAgg", "instancesAgg");
        SearchRequest searchRequest = this.createFinishedBatchOperationsSearchRequest(aggregation);
        Function<Throwable, String> errorMessage = t -> String.format("Exception occurred, while obtaining finished batch operations: %s", t.getMessage());
        return this.searchAsync(searchRequest, errorMessage);
    }

    @Override
    public CompletableFuture<ArchiveBatch> getProcessInstancesNextBatch(List<Integer> partitionIds) {
        AggregationBuilder aggregation = this.createFinishedInstancesAggregation("datesAgg", "instancesAgg");
        SearchRequest searchRequest = this.createFinishedInstancesSearchRequest(aggregation, partitionIds);
        Function<Throwable, String> errorMessage = t -> String.format("Exception occurred, while obtaining finished batch operations: %s", t.getMessage());
        return this.searchAsync(searchRequest, errorMessage);
    }

    @Override
    public void setIndexLifeCycle(String destinationIndexName) {
        try {
            if (this.operateProperties.getArchiver().isIlmEnabled() && this.esClient.indices().exists(new GetIndexRequest(new String[]{destinationIndexName}), RequestOptions.DEFAULT)) {
                this.esClient.indices().putSettings(new UpdateSettingsRequest(new String[]{destinationIndexName}).settings(Settings.builder().put("index.lifecycle.name", "operate_delete_archived_indices").build()), RequestOptions.DEFAULT);
            }
        }
        catch (Exception e) {
            LOGGER.warn("Could not set ILM policy {} for index {}: {}", new Object[]{"operate_delete_archived_indices", destinationIndexName, e.getMessage()});
        }
    }

    @Override
    public CompletableFuture<Void> deleteDocuments(String sourceIndexName, String idFieldName, List<Object> processInstanceKeys) {
        CompletableFuture<Void> deleteFuture = new CompletableFuture<Void>();
        Timer.Sample startTimer = Timer.start();
        ((CompletableFuture)ElasticsearchUtil.deleteAsyncWithConnectionRelease((ThreadPoolTaskScheduler)this.archiverExecutor, (String)sourceIndexName, (String)idFieldName, processInstanceKeys, (ObjectMapper)this.objectMapper, (RestHighLevelClient)this.esClient).thenAccept(ignore -> {
            Timer deleteTimer = this.getArchiverDeleteQueryTimer();
            startTimer.stop(deleteTimer);
            deleteFuture.complete(null);
        })).exceptionally(e -> {
            deleteFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return deleteFuture;
    }

    @Override
    public CompletableFuture<Void> reindexDocuments(String sourceIndexName, String destinationIndexName, String idFieldName, List<Object> processInstanceKeys) {
        CompletableFuture<Void> reindexFuture = new CompletableFuture<Void>();
        ReindexRequest reindexRequest = this.createReindexRequestWithDefaults().setSourceIndices(new String[]{sourceIndexName}).setDestIndex(destinationIndexName).setSourceQuery((QueryBuilder)QueryBuilders.termsQuery((String)idFieldName, processInstanceKeys));
        Timer.Sample startTimer = Timer.start();
        ((CompletableFuture)ElasticsearchUtil.reindexAsyncWithConnectionRelease((ThreadPoolTaskScheduler)this.archiverExecutor, (ReindexRequest)reindexRequest, (String)sourceIndexName, (RestHighLevelClient)this.esClient).thenAccept(ignore -> {
            Timer reindexTimer = this.getArchiverReindexQueryTimer();
            startTimer.stop(reindexTimer);
            reindexFuture.complete(null);
        })).exceptionally(e -> {
            reindexFuture.completeExceptionally((Throwable)e);
            return null;
        });
        return reindexFuture;
    }

    private SearchRequest createFinishedBatchOperationsSearchRequest(AggregationBuilder agg) {
        RangeQueryBuilder endDateQ = QueryBuilders.rangeQuery((String)"endDate").lte((Object)this.operateProperties.getArchiver().getArchivingTimepoint());
        ConstantScoreQueryBuilder q = QueryBuilders.constantScoreQuery((QueryBuilder)endDateQ);
        SearchRequest searchRequest = new SearchRequest(new String[]{this.batchOperationTemplate.getFullQualifiedName()}).source(new SearchSourceBuilder().query((QueryBuilder)q).aggregation(agg).fetchSource(false).size(0).sort("endDate", SortOrder.ASC)).requestCache(Boolean.valueOf(false));
        LOGGER.debug("Finished batch operations for archiving request: \n{}\n and aggregation: \n{}", (Object)q.toString(), (Object)agg.toString());
        return searchRequest;
    }

    private AggregationBuilder createFinishedBatchOperationsAggregation(String datesAggName, String instancesAggName) {
        return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)datesAggName).field("endDate")).calendarInterval(new DateHistogramInterval(this.operateProperties.getArchiver().getRolloverInterval())).format(this.operateProperties.getArchiver().getElsRolloverDateFormat())).keyed(true).subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.bucketSort((String)"datesSortedAgg", Arrays.asList(new FieldSortBuilder("_key"))).size(Integer.valueOf(1)))).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)instancesAggName).size(this.operateProperties.getArchiver().getRolloverBatchSize()).sort("id", SortOrder.ASC).fetchSource("id", null));
    }

    private Either<Throwable, ArchiveBatch> handleSearchResponse(SearchResponse searchResponse, Throwable error, Function<Throwable, String> errorMessage) {
        if (error != null) {
            return Either.left((Object)new OperateRuntimeException(errorMessage.apply(error), error));
        }
        ArchiveBatch batch = this.createArchiveBatch(searchResponse, "datesAgg", "instancesAgg");
        return Either.right((Object)batch);
    }

    private Timer getArchiverQueryTimer() {
        return this.metrics.getTimer("operate.archiver.query", new String[0]);
    }

    private SearchRequest createFinishedInstancesSearchRequest(AggregationBuilder agg, List<Integer> partitionIds) {
        RangeQueryBuilder endDateQ = QueryBuilders.rangeQuery((String)"endDate").lte((Object)this.operateProperties.getArchiver().getArchivingTimepoint());
        TermQueryBuilder isProcessInstanceQ = QueryBuilders.termQuery((String)"joinRelation", (String)"processInstance");
        TermsQueryBuilder partitionQ = QueryBuilders.termsQuery((String)"partitionId", partitionIds);
        ConstantScoreQueryBuilder q = QueryBuilders.constantScoreQuery((QueryBuilder)ElasticsearchUtil.joinWithAnd((QueryBuilder[])new QueryBuilder[]{endDateQ, isProcessInstanceQ, partitionQ}));
        SearchRequest searchRequest = new SearchRequest(new String[]{this.processInstanceTemplate.getFullQualifiedName()}).source(new SearchSourceBuilder().query((QueryBuilder)q).aggregation(agg).fetchSource(false).size(0).sort("endDate", SortOrder.ASC)).requestCache(Boolean.valueOf(false));
        LOGGER.debug("Finished process instances for archiving request: \n{}\n and aggregation: \n{}", (Object)q.toString(), (Object)agg.toString());
        return searchRequest;
    }

    private AggregationBuilder createFinishedInstancesAggregation(String datesAggName, String instancesAggName) {
        return ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)AggregationBuilders.dateHistogram((String)datesAggName).field("endDate")).calendarInterval(new DateHistogramInterval(this.operateProperties.getArchiver().getRolloverInterval())).format(this.operateProperties.getArchiver().getElsRolloverDateFormat())).keyed(true).subAggregation((PipelineAggregationBuilder)PipelineAggregatorBuilders.bucketSort((String)"datesSortedAgg", Arrays.asList(new FieldSortBuilder("_key"))).size(Integer.valueOf(1)))).subAggregation((AggregationBuilder)AggregationBuilders.topHits((String)instancesAggName).size(this.operateProperties.getArchiver().getRolloverBatchSize()).sort("id", SortOrder.ASC).fetchSource("id", null));
    }

    private ReindexRequest createReindexRequestWithDefaults() {
        ReindexRequest reindexRequest = (ReindexRequest)((ReindexRequest)((ReindexRequest)new ReindexRequest().setScroll(TimeValue.timeValueMillis((long)30000L))).setAbortOnVersionConflict(false)).setSlices(0);
        return reindexRequest;
    }

    private Timer getArchiverReindexQueryTimer() {
        return this.metrics.getTimer("operate.archiver.reindex.query", new String[0]);
    }

    private Timer getArchiverDeleteQueryTimer() {
        return this.metrics.getTimer("operate.archiver.delete.query", new String[0]);
    }
}

