/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.archiver;

import io.camunda.operate.Metrics;
import io.camunda.operate.archiver.AbstractArchiverJob;
import io.camunda.operate.archiver.ArchiveBatch;
import io.camunda.operate.archiver.Archiver;
import io.camunda.operate.archiver.ArchiverRepository;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.schema.templates.BatchOperationTemplate;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BatchOperationArchiverJob
extends AbstractArchiverJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(BatchOperationArchiverJob.class);
    private final Archiver archiver;
    @Autowired
    private BatchOperationTemplate batchOperationTemplate;
    @Autowired
    private OperateProperties operateProperties;
    @Autowired
    private Metrics metrics;
    @Autowired
    private ArchiverRepository archiverRepository;

    public BatchOperationArchiverJob(Archiver archiver) {
        this.archiver = archiver;
    }

    @Override
    public CompletableFuture<Integer> archiveBatch(ArchiveBatch archiveBatch) {
        CompletableFuture<Integer> archiveBatchFuture;
        if (archiveBatch != null) {
            LOGGER.debug("Following batch operations are found for archiving: {}", (Object)archiveBatch);
            archiveBatchFuture = new CompletableFuture();
            this.archiver.moveDocuments(this.batchOperationTemplate.getFullQualifiedName(), "id", archiveBatch.getFinishDate(), archiveBatch.getIds()).whenComplete((v, e) -> {
                if (e != null) {
                    archiveBatchFuture.completeExceptionally((Throwable)e);
                    return;
                }
                archiveBatchFuture.complete(archiveBatch.getIds().size());
            });
        } else {
            LOGGER.debug("Nothing to archive");
            archiveBatchFuture = CompletableFuture.completedFuture(0);
        }
        return archiveBatchFuture;
    }

    @Override
    public CompletableFuture<ArchiveBatch> getNextBatch() {
        return this.archiverRepository.getBatchOperationNextBatch();
    }
}

