/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.archiver;

import io.camunda.operate.archiver.ArchiverRepository;
import io.camunda.operate.archiver.BatchOperationArchiverJob;
import io.camunda.operate.archiver.ProcessInstancesArchiverJob;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.CollectionUtil;
import io.camunda.operate.zeebe.PartitionHolder;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.DependsOn;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"schemaStartup"})
public class Archiver {
    protected static final String INDEX_NAME_PATTERN = "%s%s";
    private static final Logger LOGGER = LoggerFactory.getLogger(Archiver.class);
    @Autowired
    protected BeanFactory beanFactory;
    @Autowired
    protected OperateProperties operateProperties;
    @Autowired
    protected PartitionHolder partitionHolder;
    @Autowired
    @Qualifier(value="archiverThreadPoolExecutor")
    protected ThreadPoolTaskScheduler archiverExecutor;
    @Autowired
    protected ArchiverRepository archiverRepository;

    @PostConstruct
    public void startArchiving() {
        if (this.operateProperties.getArchiver().isRolloverEnabled()) {
            LOGGER.info("INIT: Start archiving data...");
            List partitionIds = this.partitionHolder.getPartitionIds();
            LOGGER.info("Starting archiver for partitions: {}", (Object)partitionIds);
            int threadsCount = this.operateProperties.getArchiver().getThreadsCount();
            if (threadsCount > partitionIds.size()) {
                LOGGER.warn("Too many archiver threads are configured, not all of them will be in use. Number of threads: {}, number of partitions to parallelize by: {}", (Object)threadsCount, (Object)partitionIds.size());
            }
            for (int i = 0; i < threadsCount; ++i) {
                List partitionIdsSubset = CollectionUtil.splitAndGetSublist((List)partitionIds, (int)threadsCount, (int)i);
                if (!partitionIdsSubset.isEmpty()) {
                    ProcessInstancesArchiverJob archiverJob = (ProcessInstancesArchiverJob)this.beanFactory.getBean(ProcessInstancesArchiverJob.class, new Object[]{this, partitionIdsSubset});
                    this.archiverExecutor.execute((Runnable)archiverJob);
                }
                if (!partitionIdsSubset.contains(1)) continue;
                BatchOperationArchiverJob batchOperationArchiverJob = (BatchOperationArchiverJob)this.beanFactory.getBean(BatchOperationArchiverJob.class, new Object[]{this});
                this.archiverExecutor.execute((Runnable)batchOperationArchiverJob);
            }
        }
    }

    public CompletableFuture<Void> moveDocuments(String sourceIndexName, String idFieldName, String finishDate, List<Object> ids) {
        String destinationIndexName = this.getDestinationIndexName(sourceIndexName, finishDate);
        return this.archiverRepository.reindexDocuments(sourceIndexName, destinationIndexName, idFieldName, ids).thenCompose(ignore -> {
            this.archiverRepository.setIndexLifeCycle(destinationIndexName);
            return this.archiverRepository.deleteDocuments(sourceIndexName, idFieldName, ids);
        });
    }

    public String getDestinationIndexName(String sourceIndexName, String finishDate) {
        return String.format(INDEX_NAME_PATTERN, sourceIndexName, finishDate);
    }
}

