/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.operate.archiver;

import io.camunda.operate.archiver.ArchiverJob;
import io.camunda.operate.property.OperateProperties;
import io.camunda.operate.util.BackoffIdleStrategy;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;

public abstract class AbstractArchiverJob
implements ArchiverJob {
    public static final String DATES_AGG = "datesAgg";
    public static final String INSTANCES_AGG = "instancesAgg";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractArchiverJob.class);
    @Autowired
    @Qualifier(value="archiverThreadPoolExecutor")
    protected ThreadPoolTaskScheduler archiverExecutor;
    private final BackoffIdleStrategy idleStrategy = new BackoffIdleStrategy(2000L, 1.2f, 60000L);
    private final BackoffIdleStrategy errorStrategy = new BackoffIdleStrategy(100L, 1.2f, 10000L);
    private boolean shutdown = false;
    @Autowired
    private OperateProperties operateProperties;

    @Override
    public void run() {
        ((CompletableFuture)((CompletableFuture)this.archiveNextBatch().thenApply(count -> {
            this.errorStrategy.reset();
            if (count >= this.operateProperties.getArchiver().getRolloverBatchSize()) {
                this.idleStrategy.reset();
            } else {
                this.idleStrategy.idle();
            }
            long delay = Math.max((long)this.operateProperties.getArchiver().getDelayBetweenRuns(), this.idleStrategy.idleTime());
            return delay;
        })).exceptionally(t -> {
            LOGGER.error("Error occurred while archiving data. Will be retried.", t);
            this.errorStrategy.idle();
            long delay = Math.max((long)this.operateProperties.getArchiver().getDelayBetweenRuns(), this.errorStrategy.idleTime());
            return delay;
        })).thenAccept(delay -> {
            if (!this.shutdown) {
                this.archiverExecutor.schedule((Runnable)this, Date.from(Instant.now().plusMillis((long)delay)));
            }
        });
    }

    @Override
    public CompletableFuture<Integer> archiveNextBatch() {
        return this.getNextBatch().thenCompose(this::archiveBatch);
    }

    @PreDestroy
    public void shutdown() {
        this.shutdown = true;
    }
}

