/*
 * Tasklist REST API
 * Tasklist is a ready-to-use API application to rapidly implement business processes alongside user tasks in Zeebe.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.tasklist.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.tasklist.generated.model.BrokerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * The response of a topology request.
 */
@JsonPropertyOrder({
  TopologyResponse.JSON_PROPERTY_BROKERS,
  TopologyResponse.JSON_PROPERTY_CLUSTER_SIZE,
  TopologyResponse.JSON_PROPERTY_PARTITIONS_COUNT,
  TopologyResponse.JSON_PROPERTY_REPLICATION_FACTOR,
  TopologyResponse.JSON_PROPERTY_GATEWAY_VERSION
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-18T04:44:54.772534150Z[Etc/UTC]", comments = "Generator version: 7.8.0")
public class TopologyResponse {
  public static final String JSON_PROPERTY_BROKERS = "brokers";
  private List<BrokerInfo> brokers;

  public static final String JSON_PROPERTY_CLUSTER_SIZE = "clusterSize";
  private Integer clusterSize;

  public static final String JSON_PROPERTY_PARTITIONS_COUNT = "partitionsCount";
  private Integer partitionsCount;

  public static final String JSON_PROPERTY_REPLICATION_FACTOR = "replicationFactor";
  private Integer replicationFactor;

  public static final String JSON_PROPERTY_GATEWAY_VERSION = "gatewayVersion";
  private String gatewayVersion;

  public TopologyResponse() {
  }

  public TopologyResponse brokers(List<BrokerInfo> brokers) {
    
    this.brokers = brokers;
    return this;
  }

  public TopologyResponse addBrokersItem(BrokerInfo brokersItem) {
    if (this.brokers == null) {
      this.brokers = new ArrayList<>();
    }
    this.brokers.add(brokersItem);
    return this;
  }

  /**
   * A list of brokers that are part of this cluster.
   * @return brokers
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_BROKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<BrokerInfo> getBrokers() {
    return brokers;
  }


  @JsonProperty(JSON_PROPERTY_BROKERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setBrokers(List<BrokerInfo> brokers) {
    this.brokers = brokers;
  }

  public TopologyResponse clusterSize(Integer clusterSize) {
    
    this.clusterSize = clusterSize;
    return this;
  }

  /**
   * The number of brokers in the cluster.
   * @return clusterSize
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CLUSTER_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getClusterSize() {
    return clusterSize;
  }


  @JsonProperty(JSON_PROPERTY_CLUSTER_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setClusterSize(Integer clusterSize) {
    this.clusterSize = clusterSize;
  }

  public TopologyResponse partitionsCount(Integer partitionsCount) {
    
    this.partitionsCount = partitionsCount;
    return this;
  }

  /**
   * The number of partitions are spread across the cluster.
   * @return partitionsCount
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PARTITIONS_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPartitionsCount() {
    return partitionsCount;
  }


  @JsonProperty(JSON_PROPERTY_PARTITIONS_COUNT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPartitionsCount(Integer partitionsCount) {
    this.partitionsCount = partitionsCount;
  }

  public TopologyResponse replicationFactor(Integer replicationFactor) {
    
    this.replicationFactor = replicationFactor;
    return this;
  }

  /**
   * The configured replication factor for this cluster.
   * @return replicationFactor
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_REPLICATION_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getReplicationFactor() {
    return replicationFactor;
  }


  @JsonProperty(JSON_PROPERTY_REPLICATION_FACTOR)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setReplicationFactor(Integer replicationFactor) {
    this.replicationFactor = replicationFactor;
  }

  public TopologyResponse gatewayVersion(String gatewayVersion) {
    
    this.gatewayVersion = gatewayVersion;
    return this;
  }

  /**
   * The version of the Zeebe Gateway.
   * @return gatewayVersion
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_GATEWAY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getGatewayVersion() {
    return gatewayVersion;
  }


  @JsonProperty(JSON_PROPERTY_GATEWAY_VERSION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setGatewayVersion(String gatewayVersion) {
    this.gatewayVersion = gatewayVersion;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TopologyResponse topologyResponse = (TopologyResponse) o;
    return Objects.equals(this.brokers, topologyResponse.brokers) &&
        Objects.equals(this.clusterSize, topologyResponse.clusterSize) &&
        Objects.equals(this.partitionsCount, topologyResponse.partitionsCount) &&
        Objects.equals(this.replicationFactor, topologyResponse.replicationFactor) &&
        Objects.equals(this.gatewayVersion, topologyResponse.gatewayVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(brokers, clusterSize, partitionsCount, replicationFactor, gatewayVersion);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TopologyResponse {\n");
    sb.append("    brokers: ").append(toIndentedString(brokers)).append("\n");
    sb.append("    clusterSize: ").append(toIndentedString(clusterSize)).append("\n");
    sb.append("    partitionsCount: ").append(toIndentedString(partitionsCount)).append("\n");
    sb.append("    replicationFactor: ").append(toIndentedString(replicationFactor)).append("\n");
    sb.append("    gatewayVersion: ").append(toIndentedString(gatewayVersion)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `brokers` to the URL query string
    if (getBrokers() != null) {
      for (int i = 0; i < getBrokers().size(); i++) {
        if (getBrokers().get(i) != null) {
          joiner.add(getBrokers().get(i).toUrlQueryString(String.format("%sbrokers%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `clusterSize` to the URL query string
    if (getClusterSize() != null) {
      try {
        joiner.add(String.format("%sclusterSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getClusterSize()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `partitionsCount` to the URL query string
    if (getPartitionsCount() != null) {
      try {
        joiner.add(String.format("%spartitionsCount%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPartitionsCount()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `replicationFactor` to the URL query string
    if (getReplicationFactor() != null) {
      try {
        joiner.add(String.format("%sreplicationFactor%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getReplicationFactor()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `gatewayVersion` to the URL query string
    if (getGatewayVersion() != null) {
      try {
        joiner.add(String.format("%sgatewayVersion%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getGatewayVersion()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    return joiner.toString();
  }

}

