/*
 * Tasklist REST API
 * Tasklist is a ready-to-use API application to rapidly implement business processes alongside user tasks in Zeebe.
 *
 * The version of the OpenAPI document: v1
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package io.camunda.tasklist.generated.model;

import java.util.Objects;
import java.util.Arrays;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import io.camunda.tasklist.generated.model.DateFilter;
import io.camunda.tasklist.generated.model.IncludeVariable;
import io.camunda.tasklist.generated.model.RangeValueFilter;
import io.camunda.tasklist.generated.model.TaskByVariables;
import io.camunda.tasklist.generated.model.TaskOrderBy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.StringJoiner;

/**
 * Request object to search tasks by provided params.
 */
@JsonPropertyOrder({
  TaskSearchRequest.JSON_PROPERTY_STATE,
  TaskSearchRequest.JSON_PROPERTY_ASSIGNED,
  TaskSearchRequest.JSON_PROPERTY_ASSIGNEE,
  TaskSearchRequest.JSON_PROPERTY_ASSIGNEES,
  TaskSearchRequest.JSON_PROPERTY_TASK_DEFINITION_ID,
  TaskSearchRequest.JSON_PROPERTY_CANDIDATE_GROUP,
  TaskSearchRequest.JSON_PROPERTY_CANDIDATE_GROUPS,
  TaskSearchRequest.JSON_PROPERTY_CANDIDATE_USER,
  TaskSearchRequest.JSON_PROPERTY_CANDIDATE_USERS,
  TaskSearchRequest.JSON_PROPERTY_PROCESS_DEFINITION_KEY,
  TaskSearchRequest.JSON_PROPERTY_PROCESS_INSTANCE_KEY,
  TaskSearchRequest.JSON_PROPERTY_PAGE_SIZE,
  TaskSearchRequest.JSON_PROPERTY_FOLLOW_UP_DATE,
  TaskSearchRequest.JSON_PROPERTY_DUE_DATE,
  TaskSearchRequest.JSON_PROPERTY_TASK_VARIABLES,
  TaskSearchRequest.JSON_PROPERTY_TENANT_IDS,
  TaskSearchRequest.JSON_PROPERTY_SORT,
  TaskSearchRequest.JSON_PROPERTY_SEARCH_AFTER,
  TaskSearchRequest.JSON_PROPERTY_SEARCH_AFTER_OR_EQUAL,
  TaskSearchRequest.JSON_PROPERTY_SEARCH_BEFORE,
  TaskSearchRequest.JSON_PROPERTY_SEARCH_BEFORE_OR_EQUAL,
  TaskSearchRequest.JSON_PROPERTY_INCLUDE_VARIABLES,
  TaskSearchRequest.JSON_PROPERTY_IMPLEMENTATION,
  TaskSearchRequest.JSON_PROPERTY_PRIORITY
})
@jakarta.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", date = "2024-10-18T04:44:54.772534150Z[Etc/UTC]", comments = "Generator version: 7.8.0")
public class TaskSearchRequest {
  /**
   * The state of the tasks.
   */
  public enum StateEnum {
    CREATED("CREATED"),
    
    COMPLETED("COMPLETED"),
    
    CANCELED("CANCELED"),
    
    FAILED("FAILED");

    private String value;

    StateEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static StateEnum fromValue(String value) {
      for (StateEnum b : StateEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_STATE = "state";
  private StateEnum state;

  public static final String JSON_PROPERTY_ASSIGNED = "assigned";
  private Boolean assigned;

  public static final String JSON_PROPERTY_ASSIGNEE = "assignee";
  private String assignee;

  public static final String JSON_PROPERTY_ASSIGNEES = "assignees";
  private List<String> assignees;

  public static final String JSON_PROPERTY_TASK_DEFINITION_ID = "taskDefinitionId";
  private String taskDefinitionId;

  public static final String JSON_PROPERTY_CANDIDATE_GROUP = "candidateGroup";
  private String candidateGroup;

  public static final String JSON_PROPERTY_CANDIDATE_GROUPS = "candidateGroups";
  private List<String> candidateGroups;

  public static final String JSON_PROPERTY_CANDIDATE_USER = "candidateUser";
  private String candidateUser;

  public static final String JSON_PROPERTY_CANDIDATE_USERS = "candidateUsers";
  private List<String> candidateUsers;

  public static final String JSON_PROPERTY_PROCESS_DEFINITION_KEY = "processDefinitionKey";
  private String processDefinitionKey;

  public static final String JSON_PROPERTY_PROCESS_INSTANCE_KEY = "processInstanceKey";
  private String processInstanceKey;

  public static final String JSON_PROPERTY_PAGE_SIZE = "pageSize";
  private Integer pageSize;

  public static final String JSON_PROPERTY_FOLLOW_UP_DATE = "followUpDate";
  private DateFilter followUpDate;

  public static final String JSON_PROPERTY_DUE_DATE = "dueDate";
  private DateFilter dueDate;

  public static final String JSON_PROPERTY_TASK_VARIABLES = "taskVariables";
  private List<TaskByVariables> taskVariables;

  public static final String JSON_PROPERTY_TENANT_IDS = "tenantIds";
  private List<String> tenantIds;

  public static final String JSON_PROPERTY_SORT = "sort";
  private List<TaskOrderBy> sort;

  public static final String JSON_PROPERTY_SEARCH_AFTER = "searchAfter";
  private List<String> searchAfter;

  public static final String JSON_PROPERTY_SEARCH_AFTER_OR_EQUAL = "searchAfterOrEqual";
  private List<String> searchAfterOrEqual;

  public static final String JSON_PROPERTY_SEARCH_BEFORE = "searchBefore";
  private List<String> searchBefore;

  public static final String JSON_PROPERTY_SEARCH_BEFORE_OR_EQUAL = "searchBeforeOrEqual";
  private List<String> searchBeforeOrEqual;

  public static final String JSON_PROPERTY_INCLUDE_VARIABLES = "includeVariables";
  private List<IncludeVariable> includeVariables;

  /**
   * Gets or Sets implementation
   */
  public enum ImplementationEnum {
    JOB_WORKER("JOB_WORKER"),
    
    ZEEBE_USER_TASK("ZEEBE_USER_TASK");

    private String value;

    ImplementationEnum(String value) {
      this.value = value;
    }

    @JsonValue
    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    @JsonCreator
    public static ImplementationEnum fromValue(String value) {
      for (ImplementationEnum b : ImplementationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }
  }

  public static final String JSON_PROPERTY_IMPLEMENTATION = "implementation";
  private ImplementationEnum implementation;

  public static final String JSON_PROPERTY_PRIORITY = "priority";
  private RangeValueFilter priority;

  public TaskSearchRequest() {
  }

  public TaskSearchRequest state(StateEnum state) {
    
    this.state = state;
    return this;
  }

  /**
   * The state of the tasks.
   * @return state
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public StateEnum getState() {
    return state;
  }


  @JsonProperty(JSON_PROPERTY_STATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setState(StateEnum state) {
    this.state = state;
  }

  public TaskSearchRequest assigned(Boolean assigned) {
    
    this.assigned = assigned;
    return this;
  }

  /**
   * Are the tasks assigned?
   * @return assigned
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSIGNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Boolean getAssigned() {
    return assigned;
  }


  @JsonProperty(JSON_PROPERTY_ASSIGNED)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssigned(Boolean assigned) {
    this.assigned = assigned;
  }

  public TaskSearchRequest assignee(String assignee) {
    
    this.assignee = assignee;
    return this;
  }

  /**
   * Who is assigned to the tasks?
   * @return assignee
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getAssignee() {
    return assignee;
  }


  @JsonProperty(JSON_PROPERTY_ASSIGNEE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignee(String assignee) {
    this.assignee = assignee;
  }

  public TaskSearchRequest assignees(List<String> assignees) {
    
    this.assignees = assignees;
    return this;
  }

  public TaskSearchRequest addAssigneesItem(String assigneesItem) {
    if (this.assignees == null) {
      this.assignees = new ArrayList<>();
    }
    this.assignees.add(assigneesItem);
    return this;
  }

  /**
   * The assignee is one of the given assignees.
   * @return assignees
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_ASSIGNEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getAssignees() {
    return assignees;
  }


  @JsonProperty(JSON_PROPERTY_ASSIGNEES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setAssignees(List<String> assignees) {
    this.assignees = assignees;
  }

  public TaskSearchRequest taskDefinitionId(String taskDefinitionId) {
    
    this.taskDefinitionId = taskDefinitionId;
    return this;
  }

  /**
   * What&#39;s the BPMN flow node?
   * @return taskDefinitionId
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getTaskDefinitionId() {
    return taskDefinitionId;
  }


  @JsonProperty(JSON_PROPERTY_TASK_DEFINITION_ID)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaskDefinitionId(String taskDefinitionId) {
    this.taskDefinitionId = taskDefinitionId;
  }

  public TaskSearchRequest candidateGroup(String candidateGroup) {
    
    this.candidateGroup = candidateGroup;
    return this;
  }

  /**
   * Given group is in candidate groups list.
   * @return candidateGroup
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCandidateGroup() {
    return candidateGroup;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUP)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateGroup(String candidateGroup) {
    this.candidateGroup = candidateGroup;
  }

  public TaskSearchRequest candidateGroups(List<String> candidateGroups) {
    
    this.candidateGroups = candidateGroups;
    return this;
  }

  public TaskSearchRequest addCandidateGroupsItem(String candidateGroupsItem) {
    if (this.candidateGroups == null) {
      this.candidateGroups = new ArrayList<>();
    }
    this.candidateGroups.add(candidateGroupsItem);
    return this;
  }

  /**
   * At least one of the given groups is in candidate groups list.
   * @return candidateGroups
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCandidateGroups() {
    return candidateGroups;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_GROUPS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateGroups(List<String> candidateGroups) {
    this.candidateGroups = candidateGroups;
  }

  public TaskSearchRequest candidateUser(String candidateUser) {
    
    this.candidateUser = candidateUser;
    return this;
  }

  /**
   * Given user is in candidate user list.
   * @return candidateUser
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getCandidateUser() {
    return candidateUser;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_USER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateUser(String candidateUser) {
    this.candidateUser = candidateUser;
  }

  public TaskSearchRequest candidateUsers(List<String> candidateUsers) {
    
    this.candidateUsers = candidateUsers;
    return this;
  }

  public TaskSearchRequest addCandidateUsersItem(String candidateUsersItem) {
    if (this.candidateUsers == null) {
      this.candidateUsers = new ArrayList<>();
    }
    this.candidateUsers.add(candidateUsersItem);
    return this;
  }

  /**
   * At least one of the given users is in candidate user list.
   * @return candidateUsers
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getCandidateUsers() {
    return candidateUsers;
  }


  @JsonProperty(JSON_PROPERTY_CANDIDATE_USERS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setCandidateUsers(List<String> candidateUsers) {
    this.candidateUsers = candidateUsers;
  }

  public TaskSearchRequest processDefinitionKey(String processDefinitionKey) {
    
    this.processDefinitionKey = processDefinitionKey;
    return this;
  }

  /**
   * Reference to process definition (renamed equivalent of TaskQuery.processDefinitionId field).
   * @return processDefinitionKey
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessDefinitionKey() {
    return processDefinitionKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_DEFINITION_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessDefinitionKey(String processDefinitionKey) {
    this.processDefinitionKey = processDefinitionKey;
  }

  public TaskSearchRequest processInstanceKey(String processInstanceKey) {
    
    this.processInstanceKey = processInstanceKey;
    return this;
  }

  /**
   * Reference to process instance (renamed equivalent of TaskQuery.processInstanceId field)
   * @return processInstanceKey
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public String getProcessInstanceKey() {
    return processInstanceKey;
  }


  @JsonProperty(JSON_PROPERTY_PROCESS_INSTANCE_KEY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setProcessInstanceKey(String processInstanceKey) {
    this.processInstanceKey = processInstanceKey;
  }

  public TaskSearchRequest pageSize(Integer pageSize) {
    
    this.pageSize = pageSize;
    return this;
  }

  /**
   * Size of tasks page (default &#x3D; 50).
   * @return pageSize
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public Integer getPageSize() {
    return pageSize;
  }


  @JsonProperty(JSON_PROPERTY_PAGE_SIZE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  public TaskSearchRequest followUpDate(DateFilter followUpDate) {
    
    this.followUpDate = followUpDate;
    return this;
  }

  /**
   * Get followUpDate
   * @return followUpDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateFilter getFollowUpDate() {
    return followUpDate;
  }


  @JsonProperty(JSON_PROPERTY_FOLLOW_UP_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setFollowUpDate(DateFilter followUpDate) {
    this.followUpDate = followUpDate;
  }

  public TaskSearchRequest dueDate(DateFilter dueDate) {
    
    this.dueDate = dueDate;
    return this;
  }

  /**
   * Get dueDate
   * @return dueDate
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public DateFilter getDueDate() {
    return dueDate;
  }


  @JsonProperty(JSON_PROPERTY_DUE_DATE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setDueDate(DateFilter dueDate) {
    this.dueDate = dueDate;
  }

  public TaskSearchRequest taskVariables(List<TaskByVariables> taskVariables) {
    
    this.taskVariables = taskVariables;
    return this;
  }

  public TaskSearchRequest addTaskVariablesItem(TaskByVariables taskVariablesItem) {
    if (this.taskVariables == null) {
      this.taskVariables = new ArrayList<>();
    }
    this.taskVariables.add(taskVariablesItem);
    return this;
  }

  /**
   * An array of filter clauses specifying the variables to filter for.&lt;br&gt;If defined, the query returns only tasks to which all clauses apply.&lt;br&gt;However, it&#39;s important to note that this filtering mechanism is&lt;br&gt;designed to work exclusively with truncated variables. This means&lt;br&gt;variables of a larger size are not compatible with this filter, and&lt;br&gt;attempts to use them may result in inaccurate or incomplete query results.
   * @return taskVariables
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TASK_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaskByVariables> getTaskVariables() {
    return taskVariables;
  }


  @JsonProperty(JSON_PROPERTY_TASK_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTaskVariables(List<TaskByVariables> taskVariables) {
    this.taskVariables = taskVariables;
  }

  public TaskSearchRequest tenantIds(List<String> tenantIds) {
    
    this.tenantIds = tenantIds;
    return this;
  }

  public TaskSearchRequest addTenantIdsItem(String tenantIdsItem) {
    if (this.tenantIds == null) {
      this.tenantIds = new ArrayList<>();
    }
    this.tenantIds.add(tenantIdsItem);
    return this;
  }

  /**
   * An array of Tenant IDs to filter tasks. When multi-tenancy is&lt;br&gt;enabled, tasks associated with the specified tenant IDs are returned;&lt;br&gt;if disabled, this parameter is ignored.
   * @return tenantIds
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_TENANT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getTenantIds() {
    return tenantIds;
  }


  @JsonProperty(JSON_PROPERTY_TENANT_IDS)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setTenantIds(List<String> tenantIds) {
    this.tenantIds = tenantIds;
  }

  public TaskSearchRequest sort(List<TaskOrderBy> sort) {
    
    this.sort = sort;
    return this;
  }

  public TaskSearchRequest addSortItem(TaskOrderBy sortItem) {
    if (this.sort == null) {
      this.sort = new ArrayList<>();
    }
    this.sort.add(sortItem);
    return this;
  }

  /**
   * An array of objects specifying the fields to sort the results by.
   * @return sort
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<TaskOrderBy> getSort() {
    return sort;
  }


  @JsonProperty(JSON_PROPERTY_SORT)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSort(List<TaskOrderBy> sort) {
    this.sort = sort;
  }

  public TaskSearchRequest searchAfter(List<String> searchAfter) {
    
    this.searchAfter = searchAfter;
    return this;
  }

  public TaskSearchRequest addSearchAfterItem(String searchAfterItem) {
    if (this.searchAfter == null) {
      this.searchAfter = new ArrayList<>();
    }
    this.searchAfter.add(searchAfterItem);
    return this;
  }

  /**
   * Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.&lt;br&gt;It enables the API to return a page of tasks that directly follow the task identified by the provided values, with respect to the sorting order.
   * @return searchAfter
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEARCH_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSearchAfter() {
    return searchAfter;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_AFTER)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchAfter(List<String> searchAfter) {
    this.searchAfter = searchAfter;
  }

  public TaskSearchRequest searchAfterOrEqual(List<String> searchAfterOrEqual) {
    
    this.searchAfterOrEqual = searchAfterOrEqual;
    return this;
  }

  public TaskSearchRequest addSearchAfterOrEqualItem(String searchAfterOrEqualItem) {
    if (this.searchAfterOrEqual == null) {
      this.searchAfterOrEqual = new ArrayList<>();
    }
    this.searchAfterOrEqual.add(searchAfterOrEqualItem);
    return this;
  }

  /**
   * Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.&lt;br&gt;It enables the API to return a page of tasks that directly follow or are equal to the task identified by the provided values, with respect to the sorting order.
   * @return searchAfterOrEqual
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEARCH_AFTER_OR_EQUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSearchAfterOrEqual() {
    return searchAfterOrEqual;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_AFTER_OR_EQUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchAfterOrEqual(List<String> searchAfterOrEqual) {
    this.searchAfterOrEqual = searchAfterOrEqual;
  }

  public TaskSearchRequest searchBefore(List<String> searchBefore) {
    
    this.searchBefore = searchBefore;
    return this;
  }

  public TaskSearchRequest addSearchBeforeItem(String searchBeforeItem) {
    if (this.searchBefore == null) {
      this.searchBefore = new ArrayList<>();
    }
    this.searchBefore.add(searchBeforeItem);
    return this;
  }

  /**
   * Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.&lt;br&gt;It enables the API to return a page of tasks that directly precede the task identified by the provided values, with respect to the sorting order.
   * @return searchBefore
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEARCH_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSearchBefore() {
    return searchBefore;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_BEFORE)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchBefore(List<String> searchBefore) {
    this.searchBefore = searchBefore;
  }

  public TaskSearchRequest searchBeforeOrEqual(List<String> searchBeforeOrEqual) {
    
    this.searchBeforeOrEqual = searchBeforeOrEqual;
    return this;
  }

  public TaskSearchRequest addSearchBeforeOrEqualItem(String searchBeforeOrEqualItem) {
    if (this.searchBeforeOrEqual == null) {
      this.searchBeforeOrEqual = new ArrayList<>();
    }
    this.searchBeforeOrEqual.add(searchBeforeOrEqualItem);
    return this;
  }

  /**
   * Used to return a paginated result. Array of values that should be copied from sortValues of one of the tasks from the current search results page.&lt;br&gt;It enables the API to return a page of tasks that directly precede or are equal to the task identified by the provided values, with respect to the sorting order.
   * @return searchBeforeOrEqual
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_SEARCH_BEFORE_OR_EQUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<String> getSearchBeforeOrEqual() {
    return searchBeforeOrEqual;
  }


  @JsonProperty(JSON_PROPERTY_SEARCH_BEFORE_OR_EQUAL)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setSearchBeforeOrEqual(List<String> searchBeforeOrEqual) {
    this.searchBeforeOrEqual = searchBeforeOrEqual;
  }

  public TaskSearchRequest includeVariables(List<IncludeVariable> includeVariables) {
    
    this.includeVariables = includeVariables;
    return this;
  }

  public TaskSearchRequest addIncludeVariablesItem(IncludeVariable includeVariablesItem) {
    if (this.includeVariables == null) {
      this.includeVariables = new ArrayList<>();
    }
    this.includeVariables.add(includeVariablesItem);
    return this;
  }

  /**
   * An array used to specify a list of variable names that should be included in the response when querying tasks.&lt;br&gt;This field allows users to selectively retrieve specific variables associated with the tasks returned in the search results.
   * @return includeVariables
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_INCLUDE_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public List<IncludeVariable> getIncludeVariables() {
    return includeVariables;
  }


  @JsonProperty(JSON_PROPERTY_INCLUDE_VARIABLES)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setIncludeVariables(List<IncludeVariable> includeVariables) {
    this.includeVariables = includeVariables;
  }

  public TaskSearchRequest implementation(ImplementationEnum implementation) {
    
    this.implementation = implementation;
    return this;
  }

  /**
   * Get implementation
   * @return implementation
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_IMPLEMENTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public ImplementationEnum getImplementation() {
    return implementation;
  }


  @JsonProperty(JSON_PROPERTY_IMPLEMENTATION)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setImplementation(ImplementationEnum implementation) {
    this.implementation = implementation;
  }

  public TaskSearchRequest priority(RangeValueFilter priority) {
    
    this.priority = priority;
    return this;
  }

  /**
   * Get priority
   * @return priority
   */
  @jakarta.annotation.Nullable
  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)

  public RangeValueFilter getPriority() {
    return priority;
  }


  @JsonProperty(JSON_PROPERTY_PRIORITY)
  @JsonInclude(value = JsonInclude.Include.USE_DEFAULTS)
  public void setPriority(RangeValueFilter priority) {
    this.priority = priority;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TaskSearchRequest taskSearchRequest = (TaskSearchRequest) o;
    return Objects.equals(this.state, taskSearchRequest.state) &&
        Objects.equals(this.assigned, taskSearchRequest.assigned) &&
        Objects.equals(this.assignee, taskSearchRequest.assignee) &&
        Objects.equals(this.assignees, taskSearchRequest.assignees) &&
        Objects.equals(this.taskDefinitionId, taskSearchRequest.taskDefinitionId) &&
        Objects.equals(this.candidateGroup, taskSearchRequest.candidateGroup) &&
        Objects.equals(this.candidateGroups, taskSearchRequest.candidateGroups) &&
        Objects.equals(this.candidateUser, taskSearchRequest.candidateUser) &&
        Objects.equals(this.candidateUsers, taskSearchRequest.candidateUsers) &&
        Objects.equals(this.processDefinitionKey, taskSearchRequest.processDefinitionKey) &&
        Objects.equals(this.processInstanceKey, taskSearchRequest.processInstanceKey) &&
        Objects.equals(this.pageSize, taskSearchRequest.pageSize) &&
        Objects.equals(this.followUpDate, taskSearchRequest.followUpDate) &&
        Objects.equals(this.dueDate, taskSearchRequest.dueDate) &&
        Objects.equals(this.taskVariables, taskSearchRequest.taskVariables) &&
        Objects.equals(this.tenantIds, taskSearchRequest.tenantIds) &&
        Objects.equals(this.sort, taskSearchRequest.sort) &&
        Objects.equals(this.searchAfter, taskSearchRequest.searchAfter) &&
        Objects.equals(this.searchAfterOrEqual, taskSearchRequest.searchAfterOrEqual) &&
        Objects.equals(this.searchBefore, taskSearchRequest.searchBefore) &&
        Objects.equals(this.searchBeforeOrEqual, taskSearchRequest.searchBeforeOrEqual) &&
        Objects.equals(this.includeVariables, taskSearchRequest.includeVariables) &&
        Objects.equals(this.implementation, taskSearchRequest.implementation) &&
        Objects.equals(this.priority, taskSearchRequest.priority);
  }

  @Override
  public int hashCode() {
    return Objects.hash(state, assigned, assignee, assignees, taskDefinitionId, candidateGroup, candidateGroups, candidateUser, candidateUsers, processDefinitionKey, processInstanceKey, pageSize, followUpDate, dueDate, taskVariables, tenantIds, sort, searchAfter, searchAfterOrEqual, searchBefore, searchBeforeOrEqual, includeVariables, implementation, priority);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TaskSearchRequest {\n");
    sb.append("    state: ").append(toIndentedString(state)).append("\n");
    sb.append("    assigned: ").append(toIndentedString(assigned)).append("\n");
    sb.append("    assignee: ").append(toIndentedString(assignee)).append("\n");
    sb.append("    assignees: ").append(toIndentedString(assignees)).append("\n");
    sb.append("    taskDefinitionId: ").append(toIndentedString(taskDefinitionId)).append("\n");
    sb.append("    candidateGroup: ").append(toIndentedString(candidateGroup)).append("\n");
    sb.append("    candidateGroups: ").append(toIndentedString(candidateGroups)).append("\n");
    sb.append("    candidateUser: ").append(toIndentedString(candidateUser)).append("\n");
    sb.append("    candidateUsers: ").append(toIndentedString(candidateUsers)).append("\n");
    sb.append("    processDefinitionKey: ").append(toIndentedString(processDefinitionKey)).append("\n");
    sb.append("    processInstanceKey: ").append(toIndentedString(processInstanceKey)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    followUpDate: ").append(toIndentedString(followUpDate)).append("\n");
    sb.append("    dueDate: ").append(toIndentedString(dueDate)).append("\n");
    sb.append("    taskVariables: ").append(toIndentedString(taskVariables)).append("\n");
    sb.append("    tenantIds: ").append(toIndentedString(tenantIds)).append("\n");
    sb.append("    sort: ").append(toIndentedString(sort)).append("\n");
    sb.append("    searchAfter: ").append(toIndentedString(searchAfter)).append("\n");
    sb.append("    searchAfterOrEqual: ").append(toIndentedString(searchAfterOrEqual)).append("\n");
    sb.append("    searchBefore: ").append(toIndentedString(searchBefore)).append("\n");
    sb.append("    searchBeforeOrEqual: ").append(toIndentedString(searchBeforeOrEqual)).append("\n");
    sb.append("    includeVariables: ").append(toIndentedString(includeVariables)).append("\n");
    sb.append("    implementation: ").append(toIndentedString(implementation)).append("\n");
    sb.append("    priority: ").append(toIndentedString(priority)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Convert the instance into URL query string.
   *
   * @return URL query string
   */
  public String toUrlQueryString() {
    return toUrlQueryString(null);
  }

  /**
   * Convert the instance into URL query string.
   *
   * @param prefix prefix of the query string
   * @return URL query string
   */
  public String toUrlQueryString(String prefix) {
    String suffix = "";
    String containerSuffix = "";
    String containerPrefix = "";
    if (prefix == null) {
      // style=form, explode=true, e.g. /pet?name=cat&type=manx
      prefix = "";
    } else {
      // deepObject style e.g. /pet?id[name]=cat&id[type]=manx
      prefix = prefix + "[";
      suffix = "]";
      containerSuffix = "]";
      containerPrefix = "[";
    }

    StringJoiner joiner = new StringJoiner("&");

    // add `state` to the URL query string
    if (getState() != null) {
      try {
        joiner.add(String.format("%sstate%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getState()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assigned` to the URL query string
    if (getAssigned() != null) {
      try {
        joiner.add(String.format("%sassigned%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssigned()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignee` to the URL query string
    if (getAssignee() != null) {
      try {
        joiner.add(String.format("%sassignee%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getAssignee()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `assignees` to the URL query string
    if (getAssignees() != null) {
      for (int i = 0; i < getAssignees().size(); i++) {
        try {
          joiner.add(String.format("%sassignees%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getAssignees().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `taskDefinitionId` to the URL query string
    if (getTaskDefinitionId() != null) {
      try {
        joiner.add(String.format("%staskDefinitionId%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getTaskDefinitionId()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateGroup` to the URL query string
    if (getCandidateGroup() != null) {
      try {
        joiner.add(String.format("%scandidateGroup%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCandidateGroup()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateGroups` to the URL query string
    if (getCandidateGroups() != null) {
      for (int i = 0; i < getCandidateGroups().size(); i++) {
        try {
          joiner.add(String.format("%scandidateGroups%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCandidateGroups().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `candidateUser` to the URL query string
    if (getCandidateUser() != null) {
      try {
        joiner.add(String.format("%scandidateUser%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getCandidateUser()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `candidateUsers` to the URL query string
    if (getCandidateUsers() != null) {
      for (int i = 0; i < getCandidateUsers().size(); i++) {
        try {
          joiner.add(String.format("%scandidateUsers%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getCandidateUsers().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `processDefinitionKey` to the URL query string
    if (getProcessDefinitionKey() != null) {
      try {
        joiner.add(String.format("%sprocessDefinitionKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessDefinitionKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `processInstanceKey` to the URL query string
    if (getProcessInstanceKey() != null) {
      try {
        joiner.add(String.format("%sprocessInstanceKey%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getProcessInstanceKey()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `pageSize` to the URL query string
    if (getPageSize() != null) {
      try {
        joiner.add(String.format("%spageSize%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getPageSize()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `followUpDate` to the URL query string
    if (getFollowUpDate() != null) {
      joiner.add(getFollowUpDate().toUrlQueryString(prefix + "followUpDate" + suffix));
    }

    // add `dueDate` to the URL query string
    if (getDueDate() != null) {
      joiner.add(getDueDate().toUrlQueryString(prefix + "dueDate" + suffix));
    }

    // add `taskVariables` to the URL query string
    if (getTaskVariables() != null) {
      for (int i = 0; i < getTaskVariables().size(); i++) {
        if (getTaskVariables().get(i) != null) {
          joiner.add(getTaskVariables().get(i).toUrlQueryString(String.format("%staskVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `tenantIds` to the URL query string
    if (getTenantIds() != null) {
      for (int i = 0; i < getTenantIds().size(); i++) {
        try {
          joiner.add(String.format("%stenantIds%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getTenantIds().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `sort` to the URL query string
    if (getSort() != null) {
      for (int i = 0; i < getSort().size(); i++) {
        if (getSort().get(i) != null) {
          joiner.add(getSort().get(i).toUrlQueryString(String.format("%ssort%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `searchAfter` to the URL query string
    if (getSearchAfter() != null) {
      for (int i = 0; i < getSearchAfter().size(); i++) {
        try {
          joiner.add(String.format("%ssearchAfter%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getSearchAfter().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `searchAfterOrEqual` to the URL query string
    if (getSearchAfterOrEqual() != null) {
      for (int i = 0; i < getSearchAfterOrEqual().size(); i++) {
        try {
          joiner.add(String.format("%ssearchAfterOrEqual%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getSearchAfterOrEqual().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `searchBefore` to the URL query string
    if (getSearchBefore() != null) {
      for (int i = 0; i < getSearchBefore().size(); i++) {
        try {
          joiner.add(String.format("%ssearchBefore%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getSearchBefore().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `searchBeforeOrEqual` to the URL query string
    if (getSearchBeforeOrEqual() != null) {
      for (int i = 0; i < getSearchBeforeOrEqual().size(); i++) {
        try {
          joiner.add(String.format("%ssearchBeforeOrEqual%s%s=%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix),
              URLEncoder.encode(String.valueOf(getSearchBeforeOrEqual().get(i)), "UTF-8").replaceAll("\\+", "%20")));
        } catch (UnsupportedEncodingException e) {
          // Should never happen, UTF-8 is always supported
          throw new RuntimeException(e);
        }
      }
    }

    // add `includeVariables` to the URL query string
    if (getIncludeVariables() != null) {
      for (int i = 0; i < getIncludeVariables().size(); i++) {
        if (getIncludeVariables().get(i) != null) {
          joiner.add(getIncludeVariables().get(i).toUrlQueryString(String.format("%sincludeVariables%s%s", prefix, suffix,
              "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, i, containerSuffix))));
        }
      }
    }

    // add `implementation` to the URL query string
    if (getImplementation() != null) {
      try {
        joiner.add(String.format("%simplementation%s=%s", prefix, suffix, URLEncoder.encode(String.valueOf(getImplementation()), "UTF-8").replaceAll("\\+", "%20")));
      } catch (UnsupportedEncodingException e) {
        // Should never happen, UTF-8 is always supported
        throw new RuntimeException(e);
      }
    }

    // add `priority` to the URL query string
    if (getPriority() != null) {
      joiner.add(getPriority().toUrlQueryString(prefix + "priority" + suffix));
    }

    return joiner.toString();
  }

}

