/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.query;

import io.camunda.search.clients.core.RequestBuilders;
import io.camunda.search.clients.core.SearchQueryRequest;
import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.sort.SearchSortOptions;
import io.camunda.search.clients.source.SearchSourceConfig;
import io.camunda.service.search.filter.FilterBase;
import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.query.TypedSearchQuery;
import io.camunda.service.search.result.QueryResultConfig;
import io.camunda.service.search.sort.SortOption;
import io.camunda.service.transformers.ServiceTransformer;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.service.transformers.filter.FilterTransformer;
import io.camunda.service.transformers.query.SearchRequestTransformer;
import io.camunda.service.transformers.result.ResultConfigTransformer;
import io.camunda.service.transformers.sort.FieldSortingTransformer;
import io.camunda.zeebe.util.collection.Tuple;
import java.util.List;

public final class TypedSearchQueryTransformer<F extends FilterBase, S extends SortOption>
implements SearchRequestTransformer<F, S> {
    private final ServiceTransformers transformers;

    public TypedSearchQueryTransformer(ServiceTransformers transformers) {
        this.transformers = transformers;
    }

    @Override
    public SearchQueryRequest toSearchQueryRequest(TypedSearchQuery<F, S> query, SearchQuery authCheck) {
        QueryResultConfig resultConfig;
        SearchSourceConfig searchQuerySourceConfig;
        Object[] searchAfter;
        F filter = query.filter();
        SearchQuery searchQueryFilter = this.toSearchQuery(filter, authCheck);
        List<String> indices = this.toIndices(filter);
        SearchQueryPage page = query.page();
        boolean reverse = !page.isNextPage();
        SearchQueryRequest.Builder builder = RequestBuilders.searchRequest().index(indices).query(searchQueryFilter).from(page.from()).size(page.size());
        S sort = query.sort();
        List<SearchSortOptions> sorting = this.toSearchSortOptions(sort, reverse);
        if (sorting != null && !sorting.isEmpty()) {
            builder.sort(sorting);
        }
        if ((searchAfter = page.startNextPageAfter()) != null && searchAfter.length > 0) {
            builder.searchAfter(searchAfter);
        }
        if ((searchQuerySourceConfig = this.toSearchSourceConfig(resultConfig = query.resultConfig())) != null) {
            builder.source(searchQuerySourceConfig);
        }
        return builder.build();
    }

    private SearchSourceConfig toSearchSourceConfig(QueryResultConfig resultConfig) {
        ResultConfigTransformer resultConfigTransformer = this.getResultConfigTransformer();
        return resultConfigTransformer.apply(resultConfig);
    }

    private SearchQuery toSearchQuery(F filter, SearchQuery authCheck) {
        FilterTransformer<F> filterTransformer = this.getFilterTransformer(filter.getClass());
        SearchQuery transformedQuery = filterTransformer.apply(filter);
        return SearchQueryBuilders.and((SearchQuery)transformedQuery, (SearchQuery[])new SearchQuery[]{authCheck});
    }

    private List<String> toIndices(F filter) {
        FilterTransformer<F> filterTransformer = this.getFilterTransformer(filter.getClass());
        return filterTransformer.toIndices(filter);
    }

    private List<SearchSortOptions> toSearchSortOptions(S sort, boolean reverse) {
        List<SortOption.FieldSorting> orderings = sort.getFieldSortings();
        FieldSortingTransformer sortingTransformer = this.getFieldSortingTransformer();
        return sortingTransformer.apply((Tuple<List<SortOption.FieldSorting>, Boolean>)Tuple.of(orderings, (Object)reverse));
    }

    private FilterTransformer<F> getFilterTransformer(Class<?> cls) {
        return this.transformers.getFilterTransformer(cls);
    }

    private FieldSortingTransformer getFieldSortingTransformer() {
        ServiceTransformer transformer = this.transformers.getTransformer(FieldSortingTransformer.class);
        return (FieldSortingTransformer)transformer;
    }

    private ResultConfigTransformer getResultConfigTransformer() {
        ServiceTransformer transformer = this.transformers.getTransformer(QueryResultConfig.class);
        return (ResultConfigTransformer)transformer;
    }
}

