/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.service.entities.IncidentEntity;
import io.camunda.service.search.filter.DateValueFilter;
import io.camunda.service.search.filter.IncidentFilter;
import io.camunda.service.transformers.ServiceTransformers;
import io.camunda.service.transformers.filter.DateValueFilterTransformer;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.util.List;

public class IncidentFilterTransformer
implements FilterTransformer<IncidentFilter> {
    private final ServiceTransformers transformers;

    public IncidentFilterTransformer(ServiceTransformers transformers) {
        this.transformers = transformers;
    }

    @Override
    public SearchQuery toSearchQuery(IncidentFilter filter) {
        SearchQuery keyQuery = this.getKeyQuery(filter.keys());
        SearchQuery processDefinitionKeyQuery = this.getProcessDefinitionKeyQuery(filter.processDefinitionKeys());
        SearchQuery bpmnProcessIdQuery = this.getBpmnProcessIdQuery(filter.bpmnProcessIds());
        SearchQuery processInstanceKeyQuery = this.getProcessInstanceKeyQuery(filter.processInstanceKeys());
        SearchQuery errorTypeQuery = this.getErrorTypeQuery(filter.errorTypes());
        SearchQuery errorMessageQuery = this.getErrorMessageQuery(filter.errorMessages());
        SearchQuery flowNodeIdQuery = this.getFlowNodeIdQuery(filter.flowNodeIds());
        SearchQuery flowNodeInstanceKeyQuery = this.getFlowNodeInstanceKeyQuery(filter.flowNodeInstanceKeys());
        SearchQuery creationTimeQuery = this.getCreationTimeQuery(filter.creationTime());
        SearchQuery stateQuery = this.getStateQuery(filter.states());
        SearchQuery jobKeyQuery = this.getJobKeyQuery(filter.jobKeys());
        SearchQuery treePathQuery = this.getTreePathQuery(filter.treePaths());
        SearchQuery tenantIdQuery = this.getTenantIdQuery(filter.tenantIds());
        return SearchQueryBuilders.and((SearchQuery)keyQuery, (SearchQuery[])new SearchQuery[]{processDefinitionKeyQuery, bpmnProcessIdQuery, processInstanceKeyQuery, errorTypeQuery, errorMessageQuery, flowNodeIdQuery, flowNodeInstanceKeyQuery, creationTimeQuery, stateQuery, jobKeyQuery, treePathQuery, tenantIdQuery});
    }

    @Override
    public List<String> toIndices(IncidentFilter filter) {
        return List.of("operate-incident-8.3.1_alias");
    }

    private SearchQuery getTenantIdQuery(List<String> tenantIds) {
        return SearchQueryBuilders.stringTerms((String)"tenantId", tenantIds);
    }

    private SearchQuery getJobKeyQuery(List<Long> jobKeys) {
        return SearchQueryBuilders.longTerms((String)"jobKey", jobKeys);
    }

    private SearchQuery getStateQuery(List<IncidentEntity.IncidentState> states) {
        return SearchQueryBuilders.stringTerms((String)"state", states != null ? states.stream().map(Enum::name).toList() : null);
    }

    private SearchQuery getCreationTimeQuery(DateValueFilter filter) {
        if (filter != null) {
            FilterTransformer transformer = this.transformers.getFilterTransformer(DateValueFilter.class);
            return transformer.apply(new DateValueFilterTransformer.DateFieldFilter("creationTime", filter));
        }
        return null;
    }

    private SearchQuery getBpmnProcessIdQuery(List<String> bpmnProcessIds) {
        return SearchQueryBuilders.stringTerms((String)"bpmnProcessId", bpmnProcessIds);
    }

    private SearchQuery getFlowNodeInstanceKeyQuery(List<Long> flowNodeInstanceKeys) {
        return SearchQueryBuilders.longTerms((String)"flowNodeInstanceKey", flowNodeInstanceKeys);
    }

    private SearchQuery getFlowNodeIdQuery(List<String> flowNodeIds) {
        return SearchQueryBuilders.stringTerms((String)"flowNodeId", flowNodeIds);
    }

    private SearchQuery getErrorTypeQuery(List<IncidentEntity.ErrorType> errorTypes) {
        return SearchQueryBuilders.stringTerms((String)"errorType", errorTypes != null ? errorTypes.stream().map(Enum::name).toList() : null);
    }

    private SearchQuery getProcessInstanceKeyQuery(List<Long> processInstanceKeys) {
        return SearchQueryBuilders.longTerms((String)"processInstanceKey", processInstanceKeys);
    }

    private SearchQuery getProcessDefinitionKeyQuery(List<Long> processDefinitionKeys) {
        return SearchQueryBuilders.longTerms((String)"processDefinitionKey", processDefinitionKeys);
    }

    private SearchQuery getErrorMessageQuery(List<String> errorMessages) {
        return SearchQueryBuilders.stringTerms((String)"errorMessage", errorMessages);
    }

    private SearchQuery getKeyQuery(List<Long> keys) {
        return SearchQueryBuilders.longTerms((String)"key", keys);
    }

    private SearchQuery getTreePathQuery(List<String> treePaths) {
        return SearchQueryBuilders.stringTerms((String)"treePath", treePaths);
    }
}

