/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.service.search.filter.DecisionDefinitionFilter;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.util.List;

public final class DecisionDefinitionFilterTransformer
implements FilterTransformer<DecisionDefinitionFilter> {
    @Override
    public SearchQuery toSearchQuery(DecisionDefinitionFilter filter) {
        SearchQuery decisionKeysQuery = this.getDecisionKeysQuery(filter.decisionKeys());
        SearchQuery decisionIdsQuery = this.getDmnDecisionIdsQuery(filter.dmnDecisionIds());
        SearchQuery dmnDecisionNamesQuery = this.getDmnDecisionNamesQuery(filter.dmnDecisionNames());
        SearchQuery versionsQuery = this.getVersionsQuery(filter.versions());
        SearchQuery decisionRequirementsIdsQuery = this.getDmnDecisionRequirementsIdsQuery(filter.dmnDecisionRequirementsIds());
        SearchQuery decisionRequirementsKeysQuery = this.getDecisionRequirementsKeysQuery(filter.decisionRequirementsKeys());
        SearchQuery tenantIdsQuery = this.getTenantIdsQuery(filter.tenantIds());
        return SearchQueryBuilders.and((SearchQuery)decisionKeysQuery, (SearchQuery[])new SearchQuery[]{decisionIdsQuery, dmnDecisionNamesQuery, versionsQuery, decisionRequirementsIdsQuery, decisionRequirementsKeysQuery, tenantIdsQuery});
    }

    private SearchQuery getDecisionKeysQuery(List<Long> keys) {
        return SearchQueryBuilders.longTerms((String)"key", keys);
    }

    private SearchQuery getDmnDecisionIdsQuery(List<String> dmnDecisionIds) {
        return SearchQueryBuilders.stringTerms((String)"decisionId", dmnDecisionIds);
    }

    private SearchQuery getDmnDecisionNamesQuery(List<String> dmnDecisionNames) {
        return SearchQueryBuilders.stringTerms((String)"name", dmnDecisionNames);
    }

    private SearchQuery getVersionsQuery(List<Integer> versions) {
        return SearchQueryBuilders.intTerms((String)"version", versions);
    }

    private SearchQuery getDmnDecisionRequirementsIdsQuery(List<String> dmnDecisionRequirementsIds) {
        return SearchQueryBuilders.stringTerms((String)"decisionRequirementsId", dmnDecisionRequirementsIds);
    }

    private SearchQuery getDecisionRequirementsKeysQuery(List<Long> decisionRequirementsKeys) {
        return SearchQueryBuilders.longTerms((String)"decisionRequirementsKey", decisionRequirementsKeys);
    }

    private SearchQuery getTenantIdsQuery(List<String> tenantIds) {
        return SearchQueryBuilders.stringTerms((String)"tenantId", tenantIds);
    }

    @Override
    public List<String> toIndices(DecisionDefinitionFilter filter) {
        return List.of("operate-decision-8.3.0_alias");
    }
}

