/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.transformers.filter;

import io.camunda.search.clients.query.SearchQuery;
import io.camunda.search.clients.query.SearchQueryBuilders;
import io.camunda.search.clients.query.SearchRangeQuery;
import io.camunda.service.search.filter.DateValueFilter;
import io.camunda.service.search.filter.FilterBase;
import io.camunda.service.transformers.filter.FilterTransformer;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public final class DateValueFilterTransformer
implements FilterTransformer<DateFieldFilter> {
    private final DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZZ");

    @Override
    public SearchQuery toSearchQuery(DateFieldFilter filter) {
        String field = Objects.requireNonNull(filter.field());
        DateValueFilter dateFiler = filter.filter();
        OffsetDateTime after = dateFiler.after();
        OffsetDateTime before = dateFiler.before();
        SearchRangeQuery.Builder builder = SearchQueryBuilders.range().field(field);
        if (after != null) {
            builder.gte((Object)this.formatDate(after));
        }
        if (before != null) {
            builder.lt((Object)this.formatDate(before));
        }
        return builder.format("yyyy-MM-dd'T'HH:mm:ss.SSSZZ").build().toSearchQuery();
    }

    private String formatDate(OffsetDateTime date) {
        return this.dateTimeFormatter.format(date);
    }

    public record DateFieldFilter(String field, DateValueFilter filter) implements FilterBase
    {
    }
}

