/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.service.search.query;

import io.camunda.service.search.filter.FilterBuilders;
import io.camunda.service.search.filter.UserFilter;
import io.camunda.service.search.page.SearchQueryPage;
import io.camunda.service.search.query.SearchQueryBase;
import io.camunda.service.search.query.TypedSearchQuery;
import io.camunda.service.search.query.TypedSearchQueryBuilder;
import io.camunda.service.search.sort.SortOptionBuilders;
import io.camunda.service.search.sort.UserSort;
import io.camunda.util.ObjectBuilder;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import java.util.function.Function;

public final class UserQuery
extends Record
implements TypedSearchQuery<UserFilter, UserSort> {
    private final UserFilter filter;
    private final UserSort sort;
    private final SearchQueryPage page;

    public UserQuery(UserFilter filter, UserSort sort, SearchQueryPage page) {
        this.filter = filter;
        this.sort = sort;
        this.page = page;
    }

    public static UserQuery of(Function<Builder, ObjectBuilder<UserQuery>> fn) {
        return (UserQuery)fn.apply(new Builder()).build();
    }

    @Override
    public final String toString() {
        return ObjectMethods.bootstrap("toString", new MethodHandle[]{UserQuery.class, "filter;sort;page", "filter", "sort", "page"}, this);
    }

    @Override
    public final int hashCode() {
        return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{UserQuery.class, "filter;sort;page", "filter", "sort", "page"}, this);
    }

    @Override
    public final boolean equals(Object o) {
        return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{UserQuery.class, "filter;sort;page", "filter", "sort", "page"}, this, o);
    }

    @Override
    public UserFilter filter() {
        return this.filter;
    }

    @Override
    public UserSort sort() {
        return this.sort;
    }

    @Override
    public SearchQueryPage page() {
        return this.page;
    }

    public static final class Builder
    extends SearchQueryBase.AbstractQueryBuilder<Builder>
    implements TypedSearchQueryBuilder<UserQuery, Builder, UserFilter, UserSort> {
        private static final UserFilter EMPTY_FILTER = FilterBuilders.user().build();
        private static final UserSort EMPTY_SORT = SortOptionBuilders.user().build();
        private UserFilter filter;
        private UserSort sort;

        @Override
        public Builder filter(UserFilter value) {
            this.filter = value;
            return this;
        }

        @Override
        public Builder sort(UserSort value) {
            this.sort = value;
            return this;
        }

        @Override
        public Builder filter(Function<UserFilter.Builder, ObjectBuilder<UserFilter>> fn) {
            return this.filter(FilterBuilders.user(fn));
        }

        @Override
        public Builder sort(Function<UserSort.Builder, ObjectBuilder<UserSort>> fn) {
            return this.sort(SortOptionBuilders.user(fn));
        }

        @Override
        protected Builder self() {
            return this;
        }

        public UserQuery build() {
            return new UserQuery(Objects.requireNonNullElse(this.filter, EMPTY_FILTER), Objects.requireNonNullElse(this.sort, EMPTY_SORT), this.page());
        }
    }
}

